/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl;

import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jwt.JWTClaimsSet;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl.AbstractBuildEntityStatementAction;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.navigate.EntityStatementLifetimeLookupFunction;
import net.shibboleth.oidc.profile.config.navigate.JWTSignatureSigningConfigurationLookupFunction;
import net.shibboleth.oidc.security.CredentialConversionUtil;
import net.shibboleth.oidc.security.jose.SignatureSigningConfiguration;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.credential.Credential;
import org.slf4j.Logger;

public class BuildEntityConfiguration
extends AbstractBuildEntityStatementAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(BuildEntityConfiguration.class);
    @Nonnull
    private Function<ProfileRequestContext, List<SignatureSigningConfiguration>> signingConfigurationsLookupStrategy = new JWTSignatureSigningConfigurationLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, Duration> entityConfigurationLifetimeLookupStrategy = new EntityStatementLifetimeLookupFunction();
    @NonnullBeforeExec
    private Map<String, Map<String, Object>> metadata;

    public void setEntityConfigurationLifetimeLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.entityConfigurationLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Entity configuration lifetime lookup strategy cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.metadata = this.entityStatementCtx.getMetadata();
        if (this.metadata == null) {
            this.log.error("{} Could not resolve provider metadata", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return true;
    }

    @Override
    protected boolean populateClaimsSetBuilder(@Nonnull JWTClaimsSet.Builder builder, @Nonnull ProfileRequestContext profileRequestContext) {
        List<SignatureSigningConfiguration> signingConfigurations = this.signingConfigurationsLookupStrategy.apply(profileRequestContext);
        if (signingConfigurations == null || signingConfigurations.isEmpty()) {
            this.log.error("{} Could not fetch any signature signing configurations", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        ArrayList<JWK> jwks = new ArrayList<JWK>();
        for (SignatureSigningConfiguration signingConfiguration : signingConfigurations) {
            for (Credential credential : signingConfiguration.getSigningCredentials()) {
                JWK jwk = CredentialConversionUtil.credentialToKey((Credential)credential);
                if (jwk == null) continue;
                jwks.add(jwk);
                this.log.debug("{} Included {} to the keyset", (Object)this.getLogPrefix(), (Object)jwk.toJSONString());
            }
        }
        Duration lifetime = this.entityConfigurationLifetimeLookupStrategy.apply(profileRequestContext);
        if (lifetime == null) {
            this.log.error("{} No lifetime supplied for entity statement", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        Instant now = Instant.now();
        Instant dateExp = now.plus(lifetime);
        assert (dateExp != null);
        builder.expirationTime(Date.from(dateExp));
        builder.claim("jwks", (Object)new JWKSet(jwks).toJSONObject(true));
        builder.claim("metadata", (Object)CollectionSupport.copyToMap(this.metadata));
        return true;
    }
}

