/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl;

import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONObject;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.policy.FederationMetadataPolicyHelper;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl.RelyingPartyTrustChainContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.slf4j.Logger;

public class AbstractTrustChainResolutionAction
extends AbstractProfileAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AbstractTrustChainResolutionAction.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyTrustChainContext> trustChainContextCreationStrategy;
    @Nonnull
    private Function<List<EntityStatement>, Map<String, Map<String, Object>>> metadataLookupStrategy;
    @NonnullAfterInit
    private BiFunction<List<EntityStatement>, String, Map<String, MetadataPolicy>> metadataPolicyMergingStrategy;
    @NonnullAfterInit
    private BiFunction<Object, MetadataPolicy, Pair<Object, Boolean>> metadataPolicyEnforcer;
    @NonnullAfterInit
    private BiPredicate<String, Map<String, Object>> metadataValidationCondition;
    @Nonnull
    private List<String> arraysAsSpaceSeparatedList;

    public AbstractTrustChainResolutionAction() {
        Function tccs = new ChildContextLookup(RelyingPartyTrustChainContext.class, true).compose((Function)new InboundMessageContextLookup());
        assert (tccs != null);
        this.trustChainContextCreationStrategy = tccs;
        this.arraysAsSpaceSeparatedList = CollectionSupport.listOf((Object)"scope");
    }

    public void setTrustChainContextCreationStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyTrustChainContext> strategy) {
        this.checkSetterPreconditions();
        this.trustChainContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"TrustChainContextCreationStrategy cannot be null");
    }

    @Nonnull
    public Function<ProfileRequestContext, RelyingPartyTrustChainContext> getTrustChainContextCreationStrategy() {
        this.checkComponentActive();
        return this.trustChainContextCreationStrategy;
    }

    public void setMetadataLookupStrategy(@Nonnull Function<List<EntityStatement>, Map<String, Map<String, Object>>> strategy) {
        this.checkSetterPreconditions();
        this.metadataLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"MetadataLookupStrategy cannot be null");
    }

    @Nonnull
    public Function<List<EntityStatement>, Map<String, Map<String, Object>>> getMetadataLookupStrategy() {
        this.checkComponentActive();
        return this.metadataLookupStrategy;
    }

    public void setMetadataPolicyMergingStrategy(@Nonnull BiFunction<List<EntityStatement>, String, Map<String, MetadataPolicy>> strategy) {
        this.checkSetterPreconditions();
        this.metadataPolicyMergingStrategy = (BiFunction)Constraint.isNotNull(strategy, (String)"MetadataPolicyMergingStrategy cannot be null");
    }

    @Nonnull
    public BiFunction<List<EntityStatement>, String, Map<String, MetadataPolicy>> getMetadataPolicyMergingStrategy() {
        this.checkComponentActive();
        assert (this.metadataPolicyMergingStrategy != null);
        return this.metadataPolicyMergingStrategy;
    }

    public void setMetadataPolicyEnforcer(@Nonnull BiFunction<Object, MetadataPolicy, Pair<Object, Boolean>> enforcer) {
        this.checkSetterPreconditions();
        this.metadataPolicyEnforcer = (BiFunction)Constraint.isNotNull(enforcer, (String)"Metadata policy enforcer cannot be null");
    }

    @Nonnull
    public BiFunction<Object, MetadataPolicy, Pair<Object, Boolean>> getMetadataPolicyEnforcer() {
        this.checkComponentActive();
        assert (this.metadataPolicyEnforcer != null);
        return this.metadataPolicyEnforcer;
    }

    public void setArraysAsSpaceSeparatedList(@Nonnull List<String> list) {
        this.checkSetterPreconditions();
        this.arraysAsSpaceSeparatedList = (List)Constraint.isNotNull(list, (String)"ArraysAsSpaceSeparatedList cannot be null");
    }

    @Nonnull
    public List<String> getArraysAsSpaceSeparatedList() {
        this.checkComponentActive();
        return this.arraysAsSpaceSeparatedList;
    }

    public void setMetadataValidationCondition(@Nonnull BiPredicate<String, Map<String, Object>> condition) {
        this.checkSetterPreconditions();
        this.metadataValidationCondition = (BiPredicate)Constraint.isNotNull(condition, (String)"MetadataValidationCondition cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.metadataPolicyMergingStrategy == null) {
            throw new ComponentInitializationException("MetadataPolicyMergingStrategy cannot be null");
        }
        if (this.metadataPolicyEnforcer == null) {
            throw new ComponentInitializationException("MetadataPolicyEnforcer cannot be null");
        }
        if (this.metadataValidationCondition == null) {
            throw new ComponentInitializationException("MetadataValidationCondition cannot be null");
        }
    }

    @Nullable
    protected String populatePolicyComplaintChains(@Nonnull List<EntityStatement> chain, @Nonnull List<Pair<List<EntityStatement>, Map<String, Map<String, Object>>>> policyCompliantChains) {
        Map<String, Map<String, Object>> metadata = this.getMetadataLookupStrategy().apply(chain);
        this.log.trace("{} Metadata resolved via lookup strategy: {}", (Object)this.getLogPrefix(), metadata);
        if (metadata != null) {
            HashMap<String, JSONObject> verifiedMetadata = new HashMap<String, JSONObject>();
            for (String entityType : metadata.keySet()) {
                Map<String, MetadataPolicy> mergedPolicies;
                try {
                    mergedPolicies = this.getMetadataPolicyMergingStrategy().apply(chain, entityType);
                    this.log.debug("{} Merged policy for type {} for chain {}", new Object[]{this.getLogPrefix(), entityType, mergedPolicies});
                }
                catch (ConstraintViolationException e) {
                    this.log.warn("{} Could not merge metadata policies", (Object)this.getLogPrefix(), (Object)e);
                    return "InvalidMetadataPolicy";
                }
                JSONObject requestMetadata = new JSONObject(metadata.get(entityType));
                for (String claim : mergedPolicies.keySet()) {
                    assert (claim != null);
                    MetadataPolicy policy = mergedPolicies.get(claim);
                    try {
                        Object enforcedValue = this.enforceValue(claim, requestMetadata.get((Object)claim), policy);
                        requestMetadata.put((Object)claim, enforcedValue);
                    }
                    catch (ConstraintViolationException e) {
                        this.log.warn("{} The requested metadata is not compliant with the policy", (Object)this.getLogPrefix());
                        return "InvalidMetadataAgainstPolicy";
                    }
                }
                this.log.debug("{} The requested metadata is compliant with the policy", (Object)this.getLogPrefix());
                if (this.metadataValidationCondition.test(entityType, (Map<String, Object>)requestMetadata)) {
                    verifiedMetadata.put(entityType, requestMetadata);
                    this.log.debug("{} Policy-enforced metadata {}", (Object)this.getLogPrefix(), (Object)requestMetadata.toJSONString());
                    continue;
                }
                this.log.warn("{} Metadata validation failed for {} for entity type {}", new Object[]{this.getLogPrefix(), chain.get(0).getEntityID(), entityType});
            }
            policyCompliantChains.add((Pair<List<EntityStatement>, Map<String, Map<String, Object>>>)new Pair(chain, verifiedMetadata));
            this.log.debug("{} Policy-enforced metadata {}", (Object)this.getLogPrefix(), verifiedMetadata);
            return null;
        }
        return "InvalidMessageContext";
    }

    @Nullable
    protected Object enforceValue(@Nonnull String claim, @Nullable Object value, @Nullable MetadataPolicy policy) throws ConstraintViolationException {
        Boolean enforcerResult;
        this.log.debug("{} Claim {} set in policy included in the request: {}", new Object[]{this.getLogPrefix(), claim, value == null});
        Object enforcerInput = FederationMetadataPolicyHelper.transformSpaceSeparatedStringIntoList(this.arraysAsSpaceSeparatedList, claim, value);
        Pair<Object, Boolean> mergeResult = this.getMetadataPolicyEnforcer().apply(enforcerInput, policy);
        Boolean bl = enforcerResult = mergeResult != null ? (Boolean)mergeResult.getSecond() : null;
        if (enforcerResult == null || !enforcerResult.booleanValue()) {
            throw new ConstraintViolationException("Metadata claim " + claim + " is not compliant with the policy");
        }
        this.log.trace("{} Validation result is OK for claim {}", (Object)this.getLogPrefix(), (Object)claim);
        return Optional.ofNullable(mergeResult).map(pair -> pair.getFirst()).map(result -> FederationMetadataPolicyHelper.transformListIntoSpaceSeparatedString(this.arraysAsSpaceSeparatedList, claim, result)).orElse(null);
    }
}

