/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import java.text.ParseException;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl.EntityStatementContext;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.navigate.AuthorityHintsLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.navigate.EntityStatementClaimsSetManipulationStrategyLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.oidfed.tbd.ResponseUtil;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.profile.context.navigate.IssuerLookupFunction;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import net.shibboleth.shared.security.impl.SecureRandomIdentifierGenerationStrategy;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.slf4j.Logger;

public abstract class AbstractBuildEntityStatementAction
extends AbstractProfileAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AbstractBuildEntityStatementAction.class);
    @Nonnull
    protected Logger protocolMessageLog = LoggerFactory.getLogger((String)"PROTOCOL_MESSAGE.OIDFED");
    @Nonnull
    private Function<ProfileRequestContext, String> issuerLookupStrategy = new IssuerLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, String> subjectLookupStrategy = new IssuerLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, IdentifierGenerationStrategy> idGeneratorLookupStrategy = FunctionSupport.constant((Object)new SecureRandomIdentifierGenerationStrategy());
    @Nonnull
    private Function<ProfileRequestContext, EntityStatementContext> entityStatementContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, List<String>> authorityHintsLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> entityStatementClaimsSetManipulationStrategyLookupStrategy;
    @Nullable
    private BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>> manipulationStrategy;
    @NonnullAfterInit
    private ObjectMapper objectMapper;
    @NonnullBeforeExec
    protected IdentifierGenerationStrategy idGenerator;
    @NonnullBeforeExec
    protected EntityStatementContext entityStatementCtx;

    public AbstractBuildEntityStatementAction() {
        Function escls = new ChildContextLookup(EntityStatementContext.class, true).compose((Function)new OutboundMessageContextLookup());
        assert (escls != null);
        this.entityStatementContextLookupStrategy = escls;
        this.authorityHintsLookupStrategy = new AuthorityHintsLookupFunction();
        this.entityStatementClaimsSetManipulationStrategyLookupStrategy = new EntityStatementClaimsSetManipulationStrategyLookupFunction();
    }

    public void setIdentifierGeneratorLookupStrategy(@Nonnull Function<ProfileRequestContext, IdentifierGenerationStrategy> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.idGeneratorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Identifier generation strategy cannot be null");
    }

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Issuer lookup strategy cannot be null");
    }

    public void setSubjectLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.subjectLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Subject lookup strategy cannot be null");
    }

    public void setEntityStatementContextLookupStrategy(@Nonnull Function<ProfileRequestContext, EntityStatementContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.entityStatementContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"EntityStatementContext lookup strategy cannot be null");
    }

    public void setEntityStatementClaimsSetManipulationStrategyLookupStrategy(@Nonnull Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.entityStatementClaimsSetManipulationStrategyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Manipulation strategy lookup strategy cannot be null");
    }

    public void setObjectMapper(@Nonnull ObjectMapper mapper) {
        this.checkSetterPreconditions();
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"Object mapper cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.objectMapper == null) {
            throw new ComponentInitializationException("Object mapper cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.idGenerator = this.idGeneratorLookupStrategy.apply(profileRequestContext);
        if (this.idGenerator == null) {
            this.log.error("{} No identifier generation strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.entityStatementCtx = this.entityStatementContextLookupStrategy.apply(profileRequestContext);
        if (this.entityStatementCtx == null) {
            this.log.error("{} Unable to fetch EntityStatementContext", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.manipulationStrategy = this.entityStatementClaimsSetManipulationStrategyLookupStrategy.apply(profileRequestContext);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        JWTClaimsSet claimsSet;
        block10: {
            String issuer = this.issuerLookupStrategy.apply(profileRequestContext);
            String subject = this.subjectLookupStrategy.apply(profileRequestContext);
            Instant now = Instant.now();
            JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder().issuer(issuer).subject(subject).issueTime(Date.from(now)).claim("authority_hints", this.authorityHintsLookupStrategy.apply(profileRequestContext));
            assert (builder != null);
            if (!this.populateClaimsSetBuilder(builder, profileRequestContext)) {
                return;
            }
            claimsSet = builder.build();
            assert (claimsSet != null);
            if (this.manipulationStrategy != null) {
                this.log.debug("{} Manipulation strategy has been set, applying it to the claims set {}", (Object)this.getLogPrefix(), (Object)claimsSet.toJSONObject());
                assert (this.manipulationStrategy != null);
                Map<String, Object> result = this.manipulationStrategy.apply(profileRequestContext, claimsSet.toJSONObject());
                if (result == null) {
                    this.log.debug("{} Manipulation strategy returned null, leaving statement claims set untouched.", (Object)this.getLogPrefix());
                    break block10;
                } else {
                    this.log.debug("{} Applying the manipulated claims into the entity statement claims set", (Object)this.getLogPrefix());
                    try {
                        JWTClaimsSet parsedSet = JWTClaimsSet.parse(result);
                        assert (parsedSet != null);
                        this.logAndConstructEntityStatement(parsedSet);
                        return;
                    }
                    catch (ParseException e) {
                        this.log.error("{} The resulted claims set could not be transformed into ", (Object)this.getLogPrefix(), (Object)e);
                        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
                        return;
                    }
                }
            }
            this.log.debug("{} No manipulation strategy configured", (Object)this.getLogPrefix());
        }
        this.logAndConstructEntityStatement(claimsSet);
    }

    protected abstract boolean populateClaimsSetBuilder(@Nonnull JWTClaimsSet.Builder var1, @Nonnull ProfileRequestContext var2);

    protected void logAndConstructEntityStatement(@Nonnull JWTClaimsSet claimsSet) {
        this.log.trace("{} Building JWT from the claims set {}", (Object)this.getLogPrefix(), (Object)claimsSet);
        PlainJWT jwt = new PlainJWT(claimsSet);
        assert (this.objectMapper != null);
        try {
            this.protocolMessageLog.trace("Entity statement payload contents:\n{}", (Object)ResponseUtil.getJwtProtocolMessage((JWT)jwt, (ObjectMapper)this.objectMapper));
        }
        catch (ParseException e) {
            this.log.error("{} Could not construct protocol log message", (Object)this.getLogPrefix(), (Object)e);
        }
        assert (this.entityStatementCtx != null);
        this.entityStatementCtx.setJWT((JWT)jwt);
    }
}

