/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.policy.impl;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.policy.impl.AbstractFederationMetadataPolicyOperator;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.oidc.metadata.policy.impl.MetadataPolicyHelper;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class DefaultFederationMetadataPolicyValueOperator
extends AbstractFederationMetadataPolicyOperator {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultFederationMetadataPolicyValueOperator.class);

    @Override
    @Nullable
    public Object apply(@Nullable Object candidate, @Nonnull MetadataPolicy policy) throws ConstraintViolationException {
        Optional optional;
        Object value = policy.getValue();
        return value != null ? (value instanceof Optional && (optional = (Optional)value).isEmpty() ? null : value) : candidate;
    }

    @Override
    public boolean validate(@Nonnull MetadataPolicy policy) {
        List supersetOf;
        List subsetOf;
        Optional optional;
        Object value = policy.getValue();
        if (value instanceof Optional && (optional = (Optional)value).isEmpty()) {
            if (policy.isEssential()) {
                this.log.debug("Value for the value operator is null and essential is true");
                return false;
            }
            if (policy.getDefaultValue() != null) {
                this.log.debug("Null value cannot be combined with non-empty default: {}", policy.getDefaultValue());
                return false;
            }
            this.log.debug("Value for the value operator is null and essential is false");
            return true;
        }
        if (value == null) {
            return true;
        }
        boolean validation = true;
        List oneOf = policy.getOneOfValues();
        if (oneOf != null && !oneOf.contains(value)) {
            this.log.debug("Value {} is not included in the one_of values {}", value, (Object)oneOf);
            validation = false;
        }
        if ((subsetOf = policy.getSubsetOfValues()) != null && !MetadataPolicyHelper.isSubsetOfValues((Object)value, (Collection)subsetOf)) {
            this.log.debug("Value {} is not included in the of subset_of values {}", value, (Object)subsetOf);
            validation = false;
        }
        if ((supersetOf = policy.getSupersetOfValues()) != null && !MetadataPolicyHelper.isSupersetOfValues((Object)value, (Collection)supersetOf)) {
            this.log.debug("Value {} is not included in the of superset_of values {}", value, (Object)supersetOf);
            validation = false;
        }
        return validation;
    }
}

