/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.policy;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.policy.FederationMetadataPolicyHelper;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class FederationMetadataPolicyDeserializer
extends JsonDeserializer<MetadataPolicy> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(FederationMetadataPolicyDeserializer.class);
    @Nonnull
    private final List<String> arraysAsSpaceSeparatedList;

    public FederationMetadataPolicyDeserializer() {
        this("scope");
    }

    public FederationMetadataPolicyDeserializer(@Nonnull @ParameterName(name="arraysAsSpaceSeparatedList") String string) {
        List<String> list = Arrays.asList(Constraint.isNotEmpty((String)string, (String)"The string cannot be empty").split(","));
        assert (list != null);
        this.arraysAsSpaceSeparatedList = list;
    }

    @Nonnull
    public MetadataPolicy deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        MetadataPolicy policy = new MetadataPolicy();
        this.log.debug("Starting deseralize");
        JavaType objectType = TypeFactory.defaultInstance().constructType(Object.class);
        JavaType stringType = TypeFactory.defaultInstance().constructType(String.class);
        MapType objectMapType = TypeFactory.defaultInstance().constructMapType(Map.class, stringType, objectType);
        Map map = (Map)deserializationContext.readValue(jsonParser, (JavaType)objectMapType);
        String claim = jsonParser.getParsingContext().getCurrentName();
        if (claim == null) {
            throw new IOException("Could not find the parent claim name for the metadata policy");
        }
        this.log.debug("Processing claim {}, value {}", (Object)claim, (Object)map);
        if (map != null) {
            this.log.debug("Processing map object {}", (Object)map);
            Iterator<String> iterator = map.keySet().stream().filter(Objects::nonNull).toList().iterator();
            block20: while (iterator.hasNext()) {
                String key;
                switch (key = iterator.next()) {
                    case "value": {
                        Optional value = FederationMetadataPolicyHelper.transformSpaceSeparatedStringIntoList(this.arraysAsSpaceSeparatedList, claim, map.get("value"));
                        policy.setValue(value != null ? value : Optional.empty());
                        continue block20;
                    }
                    case "add": {
                        policy.setAdd(FederationMetadataPolicyHelper.transformSpaceSeparatedStringIntoList(this.arraysAsSpaceSeparatedList, claim, map.get("add")));
                        continue block20;
                    }
                    case "default": {
                        policy.setDefaultValue(FederationMetadataPolicyHelper.transformSpaceSeparatedStringIntoList(this.arraysAsSpaceSeparatedList, claim, map.get("default")));
                        continue block20;
                    }
                    case "essential": {
                        policy.setEssential(Boolean.valueOf(map.get("essential") != null ? Boolean.valueOf(String.valueOf(map.get("essential"))) : false));
                        continue block20;
                    }
                    case "one_of": {
                        policy.setOneOfValues(this.transformObjectIntoList("one_of", FederationMetadataPolicyHelper.transformSpaceSeparatedStringIntoList(this.arraysAsSpaceSeparatedList, claim, map.get("one_of"))));
                        continue block20;
                    }
                    case "subset_of": {
                        policy.setSubsetOfValues(this.transformObjectIntoList("subset_of", FederationMetadataPolicyHelper.transformSpaceSeparatedStringIntoList(this.arraysAsSpaceSeparatedList, claim, map.get("subset_of"))));
                        continue block20;
                    }
                    case "superset_of": {
                        policy.setSupersetOfValues(this.transformObjectIntoList("superset_of", FederationMetadataPolicyHelper.transformSpaceSeparatedStringIntoList(this.arraysAsSpaceSeparatedList, claim, map.get("superset_of"))));
                        continue block20;
                    }
                    case "regexp": {
                        policy.setRegexp(map.get("regexp") == null ? null : String.valueOf(map.get("regexp")));
                        continue block20;
                    }
                }
                policy.setCustomOperator(key, map.get(key));
            }
        } else {
            this.log.debug("No map object could be parsed from the input, leaving the policy empty");
        }
        return policy;
    }

    @Nullable
    private List<Object> transformObjectIntoList(@Nonnull String id, @Nullable Object object) throws IOException {
        if (object instanceof List) {
            List list = (List)object;
            return list.stream().filter(Object.class::isInstance).map(Object.class::cast).toList();
        }
        if (object != null) {
            throw new IOException("The value '" + String.valueOf(object) + "' for '" + id + "' is not a list");
        }
        return null;
    }
}

