/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.constraints.impl;

import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.constraints.impl.AbstractFederationPolicyConstraint;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralSubtree;
import org.bouncycastle.asn1.x509.NameConstraintValidatorException;
import org.bouncycastle.asn1.x509.PKIXNameConstraintValidator;
import org.slf4j.Logger;

public class DefaultNamingConstraintsConstraint
extends AbstractFederationPolicyConstraint<Map<String, List<String>>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultNamingConstraintsConstraint.class);

    @Override
    @Nullable
    protected Map<String, List<String>> parseConstraint(@Nullable Object constraint) throws ConstraintViolationException {
        if (constraint instanceof Map) {
            Map map = (Map)constraint;
            return map.keySet().stream().filter(key -> "permitted".equals(key) || "excluded".equals(key)).map(String::valueOf).collect(Collectors.toMap(key -> key, key -> this.parseListOfStrings((String)key, map.get(key))));
        }
        if (constraint != null) {
            throw new ConstraintViolationException("Unexpected value type for naming_constraints: " + String.valueOf(constraint));
        }
        return null;
    }

    @Nullable
    private List<String> parseListOfStrings(@Nullable String key, @Nullable Object raw) throws ConstraintViolationException {
        if (raw instanceof List) {
            List list = (List)raw;
            List<String> result = list.stream().filter(Objects::nonNull).map(String::valueOf).toList();
            return result;
        }
        if (raw != null) {
            throw new ConstraintViolationException("The value for " + key + " is not a list: " + String.valueOf(raw));
        }
        return null;
    }

    @Override
    protected boolean doValidate(@Nonnull Map<String, List<String>> constraintData, @Nonnull List<EntityStatement> trustChain) {
        PKIXNameConstraintValidator bcValidator = new PKIXNameConstraintValidator();
        Optional.ofNullable(constraintData.get("excluded")).orElseGet((Supplier<List<String>>)NonnullSupplier.of((Object)CollectionSupport.emptyList())).forEach(item -> bcValidator.addExcludedSubtree(new GeneralSubtree(new GeneralName(2, item))));
        Optional.ofNullable(constraintData.get("permitted")).orElseGet((Supplier<List<String>>)NonnullSupplier.of((Object)CollectionSupport.emptyList())).forEach(item -> bcValidator.intersectPermittedSubtree(new GeneralSubtree(new GeneralName(2, item))));
        for (EntityStatement entityStatement : trustChain) {
            String host = URI.create(entityStatement.getEntityID().getValue()).getHost();
            try {
                bcValidator.checkExcluded(new GeneralName(2, host));
                this.log.trace("Validation for 'excluded' was successful for {}", (Object)host);
            }
            catch (NameConstraintValidatorException e) {
                this.log.warn("Constraint excludes entity name {}", (Object)host);
                return false;
            }
            try {
                bcValidator.checkPermitted(new GeneralName(2, host));
                this.log.trace("Validation for 'permitted' was successful for {}", (Object)host);
            }
            catch (NameConstraintValidatorException e) {
                this.log.warn("Constraint does not permit entity name {}", (Object)host);
                return false;
            }
        }
        return true;
    }
}

