/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.constraints.impl;

import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.constraints.impl.AbstractFederationPolicyConstraint;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class DefaultMaxPathLengthConstraint
extends AbstractFederationPolicyConstraint<Integer> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultMaxPathLengthConstraint.class);

    @Override
    @Nullable
    protected Integer parseConstraint(@Nullable Object constraint) throws ConstraintViolationException {
        if (constraint instanceof Integer) {
            Integer integer = (Integer)constraint;
            return integer;
        }
        if (constraint != null) {
            throw new ConstraintViolationException("Unexpected value type for max_path_length: " + String.valueOf(constraint));
        }
        return null;
    }

    @Override
    protected boolean doValidate(@Nonnull Integer constraintData, @Nonnull List<EntityStatement> trustChain) {
        List<EntityStatement> intermediates = trustChain.stream().filter(es -> !es.getEntityID().getValue().equals(es.getClaimsSet().getIssuer().getValue())).toList();
        int length = intermediates.size();
        this.log.trace("Maximum path length: {}, amount of intermediates is {}", (Object)constraintData, (Object)length);
        if (constraintData < length) {
            this.log.warn("Maximum path length is constricted to {}, amount of intermediates is {}", (Object)constraintData, (Object)length);
            return false;
        }
        return true;
    }
}

