/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.constraints.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.EntityStatementHelper;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.constraints.impl.AbstractFederationPolicyConstraint;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class DefaultAllowedEntityTypesConstraint
extends AbstractFederationPolicyConstraint<List<String>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultAllowedEntityTypesConstraint.class);
    @NonnullAfterInit
    private ObjectMapper objectMapper;

    public void setObjectMapper(@Nonnull ObjectMapper mapper) {
        this.checkSetterPreconditions();
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"Object mapper cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.objectMapper == null) {
            throw new ComponentInitializationException("Object mapper cannot be null");
        }
    }

    @Override
    @Nullable
    protected List<String> parseConstraint(@Nullable Object constraint) throws ConstraintViolationException {
        if (constraint instanceof List) {
            List list = (List)constraint;
            return list.stream().filter(String.class::isInstance).map(String::valueOf).toList();
        }
        if (constraint != null) {
            throw new ConstraintViolationException("Unexpected value type for allowed_entity_types: " + String.valueOf(constraint));
        }
        return null;
    }

    @Override
    protected boolean doValidate(@Nonnull List<String> constraintData, @Nonnull List<EntityStatement> trustChain) {
        if (constraintData.contains("federation_entity")) {
            this.log.warn("The value 'federation_entity' is not allowed for allowed_entity_types");
            return false;
        }
        ArrayList<String> allowedTypes = new ArrayList<String>(constraintData);
        allowedTypes.add("federation_entity");
        this.log.trace("Allowed entity types: {}", allowedTypes);
        for (EntityStatement entityStatement : trustChain) {
            assert (entityStatement != null);
            assert (this.objectMapper != null);
            Map<String, Map<String, Object>> metadata = EntityStatementHelper.parseMetadata(this.objectMapper, entityStatement);
            for (String entityType : metadata.keySet()) {
                if (!allowedTypes.contains(entityType)) {
                    this.log.warn("The entity type {} is not allowed in entity statement {}", (Object)entityType, (Object)entityStatement.getEntityID());
                    return false;
                }
                this.log.trace("The entity type {} is allowed for {}", (Object)entityType, (Object)entityStatement.getEntityID());
            }
        }
        return true;
    }
}

