/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.constraints;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.EntityStatementHelper;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.constraints.FederationPolicyConstraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class FederationPolicyConstraintHelper {
    @Nonnull
    private static final Logger log = LoggerFactory.getLogger(FederationPolicyConstraintHelper.class);

    public static boolean verifyPolicyConstraints(@Nonnull ObjectMapper objectMapper, @Nullable EntityStatement subordinateStatement, @Nonnull List<EntityStatement> trustChain, @Nonnull Map<String, FederationPolicyConstraint> federationPolicyConstraints) {
        if (subordinateStatement == null) {
            return true;
        }
        Map<String, Object> constraints = EntityStatementHelper.parseClaimAsMap(objectMapper, subordinateStatement, "constraints");
        for (String constraint : constraints.keySet()) {
            FederationPolicyConstraint validator = federationPolicyConstraints.get(constraint);
            if (validator != null) {
                log.trace("Validating federation policy constraint {} with {}", (Object)constraint, (Object)validator);
                if (validator.validate(constraints.get(constraint), trustChain)) continue;
                log.warn("Subordinate statement issued by {} contained constraint {} that failed", (Object)subordinateStatement.getClaimsSet().getIssuer(), (Object)constraint);
                return false;
            }
            log.debug("Ignoring non-recognized federation policy constraint {}", (Object)constraint);
        }
        return true;
    }
}

