/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class EntityStatementHelper {
    @Nonnull
    private static final Logger log = LoggerFactory.getLogger(EntityStatementHelper.class);

    @Nonnull
    public static Map<String, Object> parseClaimAsMap(@Nonnull ObjectMapper objectMapper, @Nonnull EntityStatement entityStatement, @Nonnull String claim) {
        Object rawClaim = entityStatement.getClaimsSet().getClaim(claim);
        log.trace("Raw {} claim value: {}", (Object)claim, rawClaim);
        if (rawClaim != null) {
            JavaType objectType = objectMapper.constructType(Object.class);
            JavaType stringType = objectMapper.constructType(String.class);
            MapType objectMapType = objectMapper.getTypeFactory().constructMapType(Map.class, stringType, objectType);
            try {
                Map result = (Map)objectMapper.readValue(rawClaim.toString(), (JavaType)objectMapType);
                if (result != null) {
                    log.trace("Parsed {} map: {}", (Object)claim, (Object)result);
                    return result;
                }
            }
            catch (JsonProcessingException e) {
                log.warn("Could not parse " + claim + " from entity statement", (Throwable)e);
            }
        }
        log.trace("Returning empty map");
        return CollectionSupport.emptyMap();
    }

    @Nonnull
    public static Map<String, Map<String, Object>> parseClaimAsMapOfMaps(@Nonnull ObjectMapper objectMapper, @Nonnull EntityStatement entityStatement, @Nonnull String claim) {
        Object rawClaim = entityStatement.getClaimsSet().getClaim(claim);
        log.trace("Raw {} claim value: {}", (Object)claim, rawClaim);
        if (rawClaim != null) {
            JavaType objectType = objectMapper.constructType(Object.class);
            JavaType stringType = objectMapper.constructType(String.class);
            MapType objectMapType = objectMapper.getTypeFactory().constructMapType(Map.class, stringType, objectType);
            MapType mapOfObjectMapType = objectMapper.getTypeFactory().constructMapType(Map.class, stringType, (JavaType)objectMapType);
            try {
                Map result = (Map)objectMapper.readValue(rawClaim.toString(), (JavaType)mapOfObjectMapType);
                if (result != null) {
                    log.trace("Parsed {} map: {}", (Object)claim, (Object)result);
                    return result;
                }
            }
            catch (JsonProcessingException e) {
                log.warn("Could not parse " + claim + " from entity statement", (Throwable)e);
            }
        }
        log.trace("Returning empty map");
        return CollectionSupport.emptyMap();
    }

    @Nonnull
    public static Map<String, Map<String, Object>> parseMetadata(@Nonnull ObjectMapper objectMapper, @Nonnull EntityStatement entityStatement) {
        return EntityStatementHelper.parseClaimAsMapOfMaps(objectMapper, entityStatement, "metadata");
    }

    @Nullable
    public static EntityStatement deserializeEntityStatement(@Nullable String serialized) {
        try {
            if (serialized != null) {
                return EntityStatement.parse((String)serialized);
            }
        }
        catch (ParseException e) {
            log.trace("Could not construct entity statement from {}", (Object)serialized, (Object)e);
        }
        log.warn("Could not deserialize entity statement {}", (Object)serialized);
        return null;
    }

    @Nullable
    public static String getSerializedTrustChain(@Nullable List<EntityStatement> trustChain) {
        return trustChain == null ? null : String.join((CharSequence)",", trustChain.stream().map(es -> es.getSignedStatement().serialize()).toList());
    }

    @Nullable
    public static String getSerializedEntityStatement(@Nullable EntityStatement entityStatement) {
        return entityStatement == null ? null : entityStatement.getSignedStatement().serialize();
    }
}

