/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata;

import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.SubjectEntityIDCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.TrustMarkOwnersCriterion;
import net.shibboleth.oidc.security.credential.BasicJWKCredential;
import net.shibboleth.oidc.security.credential.impl.BasicJOSEObjectCredentialResolver;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.security.credential.Credential;
import org.slf4j.Logger;

public class DefaultTrustMarkOwnerCredentialResolver
extends BasicJOSEObjectCredentialResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultTrustMarkOwnerCredentialResolver.class);

    protected Iterable<Credential> resolveFromSource(@Nullable CriteriaSet criteriaSet) throws ResolverException {
        if (criteriaSet == null) {
            throw new ResolverException("No criteria supplied");
        }
        TrustMarkOwnersCriterion ownersCriterion = (TrustMarkOwnersCriterion)criteriaSet.get(TrustMarkOwnersCriterion.class);
        if (ownersCriterion == null) {
            this.log.debug("No TrustMarkOwnersCriterion criteria supplised, resolver could not process");
            throw new ResolverException("Credential criteria set did not contain an instance of TrustMarkOwnersCriterion");
        }
        SubjectEntityIDCriterion subjectCriterion = (SubjectEntityIDCriterion)criteriaSet.get(SubjectEntityIDCriterion.class);
        if (subjectCriterion == null) {
            this.log.debug("No SubjectEntityIDCriterion criteria supplied, resolver could not process");
            throw new ResolverException("Credential criteria set did not contain an instance of SubjectEntityIDCriterion");
        }
        String entityId = subjectCriterion.getValue();
        Map<String, Map<String, Object>> owners = ownersCriterion.getValue();
        if (owners.isEmpty() || owners.get(entityId) == null) {
            this.log.debug("No trusted owners entry found for {}", (Object)entityId);
            return CollectionSupport.emptyList();
        }
        Map<String, Object> ownerConfiguration = owners.get(entityId);
        Object object = ownerConfiguration.get("jwks");
        if (object instanceof Map) {
            JWKSet jwkSet;
            Map map = (Map)object;
            try {
                jwkSet = JWKSet.parse(map.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue())));
            }
            catch (ParseException e2) {
                this.log.debug("Could not parse JWKSet from the jwks claim", (Throwable)e2);
                return CollectionSupport.emptyList();
            }
            ArrayList<Credential> credentials = new ArrayList<Credential>();
            for (JWK jwk : jwkSet.getKeys()) {
                BasicJWKCredential cred;
                if (jwk == null || (cred = this.buildJWKCredential(jwk, null)) == null) continue;
                credentials.add((Credential)cred);
            }
            this.log.debug("Returning credentials {} for {}", credentials, (Object)entityId);
            return credentials;
        }
        this.log.debug("Could not parse jwks from {}", ownerConfiguration.get("jwks"));
        return CollectionSupport.emptyList();
    }
}

