/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONArray;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class DefaultTrustChainTrustMarksParsingStrategy
extends AbstractIdentifiableInitializableComponent
implements Function<List<EntityStatement>, Map<String, List<SignedJWT>>> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultTrustChainTrustMarksParsingStrategy.class);
    @NonnullAfterInit
    private ObjectMapper objectMapper;

    public void setObjectMapper(@Nonnull ObjectMapper mapper) {
        this.checkSetterPreconditions();
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"Object mapper cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.objectMapper == null) {
            throw new ComponentInitializationException("Object mapper cannot be null");
        }
    }

    @Override
    @Nullable
    public Map<String, List<SignedJWT>> apply(@Nullable List<EntityStatement> trustChain) {
        this.checkComponentActive();
        if (trustChain == null || trustChain.size() < 3) {
            this.log.error("Unexpected length in the trust chain: {}", trustChain == null ? "null" : Integer.valueOf(trustChain.size()));
            return null;
        }
        HashMap<String, List<SignedJWT>> result = new HashMap<String, List<SignedJWT>>();
        for (EntityStatement statement : trustChain) {
            assert (statement != null);
            SignedJWT statementJwt = statement.getSignedStatement();
            JSONArray rawTrustMarks = statement.getClaimsSet().getJSONArrayClaim("trust_marks");
            this.log.trace("Inspecting entity statement {} with trust marks {}", (Object)statementJwt.serialize(), (Object)rawTrustMarks);
            if (rawTrustMarks == null || rawTrustMarks.isEmpty()) continue;
            this.log.trace("Transforming the trust mark into a JWT");
            List<SignedJWT> trustMarks = rawTrustMarks.stream().map(entry -> this.parseTrustMark(entry)).filter(Objects::nonNull).toList();
            this.log.debug("Returning {} trust marks for entity {}", (Object)trustMarks.size(), (Object)statement.getEntityID().getValue());
            result.put(statement.getEntityID().getValue(), trustMarks);
        }
        return result;
    }

    @Nullable
    private SignedJWT parseTrustMark(@Nullable Object trustMarkEntry) {
        if (trustMarkEntry == null) {
            return null;
        }
        JavaType stringType = this.objectMapper.constructType(String.class);
        MapType stringMapType = this.objectMapper.getTypeFactory().constructMapType(Map.class, stringType, stringType);
        try {
            Map map = (Map)this.objectMapper.readValue(trustMarkEntry.toString(), (JavaType)stringMapType);
            if (map != null) {
                this.log.debug("Parsed trust_mark map {}", (Object)map);
                return this.verifyTrustMark((String)map.get("trust_mark"), (String)map.get("trust_mark_type"));
            }
        }
        catch (JsonProcessingException e) {
            this.log.warn("Could not parse trust mark issuers from the trust chain", (Throwable)e);
        }
        return null;
    }

    @Nullable
    private SignedJWT verifyTrustMark(@Nullable String trustMark, @Nullable String id) {
        if (trustMark == null || id == null) {
            this.log.trace("Could not parse trust mark {} with trust_mark_type {}", (Object)trustMark, (Object)id);
            return null;
        }
        try {
            SignedJWT jwt = SignedJWT.parse((String)trustMark);
            JWTClaimsSet trustMarkClaims = jwt.getJWTClaimsSet();
            if (StringSupport.trimOrNull((String)trustMarkClaims.getIssuer()) == null) {
                this.log.error("Trust Mark {} is missing mandatory issuer", (Object)trustMarkClaims.getStringClaim("trust_mark_type"));
                return null;
            }
            if (id.equals(trustMarkClaims.getStringClaim("trust_mark_type"))) {
                return jwt;
            }
            this.log.error("The id {} is not matching with the trust_mark_type-claim {}", (Object)id, (Object)trustMarkClaims.getStringClaim("trust_mark_type"));
        }
        catch (ParseException e) {
            this.log.error("Could not parse id-claim from the trust mark", (Throwable)e);
        }
        return null;
    }
}

