/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata;

import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.filter.MetadataFilterContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class DefaultTrustAnchorSignatureValidationFilterStrategy
extends AbstractIdentifiableInitializableComponent
implements BiFunction<List<List<EntityStatement>>, MetadataFilterContext, List<List<EntityStatement>>> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultTrustAnchorSignatureValidationFilterStrategy.class);
    @NonnullAfterInit
    private BiFunction<EntityStatement, MetadataFilterContext, EntityStatement> entityStatementSignatureValidationFilterStrategy;

    public void setEntityStatementSignatureValidationFilterStrategy(@Nonnull BiFunction<EntityStatement, MetadataFilterContext, EntityStatement> strategy) {
        this.checkSetterPreconditions();
        this.entityStatementSignatureValidationFilterStrategy = (BiFunction)Constraint.isNotNull(strategy, (String)"EntityStatementSignatureValidationFilterStrategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.entityStatementSignatureValidationFilterStrategy == null) {
            throw new ComponentInitializationException("EntityStatementSignatureValidationFilterStrategy cannot be null");
        }
    }

    @Override
    @Nullable
    public List<List<EntityStatement>> apply(@Nullable List<List<EntityStatement>> trustChains, @Nullable MetadataFilterContext filterContext) {
        this.checkComponentActive();
        if (trustChains == null) {
            return null;
        }
        ArrayList<List<EntityStatement>> result = new ArrayList<List<EntityStatement>>();
        for (List<EntityStatement> trustChain : trustChains) {
            EntityStatement trustAnchorStatement = trustChain.get(trustChain.size() - 1);
            String entityId = trustAnchorStatement.getEntityID().getValue();
            EntityStatement filteredStatement = this.entityStatementSignatureValidationFilterStrategy.apply(trustAnchorStatement, filterContext);
            if (filteredStatement != null) {
                this.log.debug("Successfully validated entity statement for trust anchor {}", (Object)entityId);
                result.add(trustChain);
                continue;
            }
            this.log.debug("Signature validation failed for trust anchor {}", (Object)entityId);
        }
        return result;
    }
}

