/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata;

import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.DefaultEntityStatementSignatureValidationFilterStrategy;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.IssuerEntityStatementCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.SubjectEntityIDCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.SubjectEntityStatementCriterion;
import net.shibboleth.oidc.metadata.cache.MetadataCache;
import net.shibboleth.oidc.metadata.cache.MetadataCacheException;
import net.shibboleth.oidc.metadata.filter.MetadataFilterContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class DefaultSubordinateStatementSignatureValidationFilterStrategy
extends DefaultEntityStatementSignatureValidationFilterStrategy {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultSubordinateStatementSignatureValidationFilterStrategy.class);
    @NonnullAfterInit
    private MetadataCache<EntityStatement> entityConfigurationCache;

    public void setEntityConfigurationCache(@Nonnull MetadataCache<EntityStatement> cache) {
        this.checkSetterPreconditions();
        this.entityConfigurationCache = (MetadataCache)Constraint.isNotNull(cache, (String)"Entity Configuration cache cannot be null");
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.entityConfigurationCache == null) {
            throw new ComponentInitializationException("Entity Configuration cache cannot be null");
        }
    }

    @Override
    @Nullable
    public EntityStatement apply(@Nullable EntityStatement entityStatement, @Nullable MetadataFilterContext filterContext) {
        this.checkComponentActive();
        if (entityStatement == null) {
            return null;
        }
        String entityId = entityStatement.getEntityID().getValue();
        String issuer = entityStatement.getClaimsSet().getIssuerEntityID().getValue();
        assert (issuer != null);
        this.log.trace("Validating subordinate statement for {}, issued by {}", (Object)entityId, (Object)issuer);
        EntityStatement issuerStatement = this.fetchIssuerStatement(issuer);
        if (issuerStatement == null) {
            return null;
        }
        CriteriaSet criteria = new CriteriaSet();
        criteria.add((Object)new IssuerEntityStatementCriterion(issuerStatement));
        criteria.add((Object)new SubjectEntityStatementCriterion(entityStatement));
        if (this.validateStatement(entityStatement, criteria, entityId)) {
            return entityStatement;
        }
        return null;
    }

    @Nullable
    protected EntityStatement fetchIssuerStatement(@Nonnull String issuer) {
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{new SubjectEntityIDCriterion(issuer)});
        try {
            List result = this.entityConfigurationCache.get(criteria);
            if (!result.isEmpty()) {
                return (EntityStatement)result.get(0);
            }
        }
        catch (MetadataCacheException e) {
            this.log.debug("Error while fetching issuer entity configuration for {}", (Object)issuer, (Object)e);
        }
        this.log.warn("Could not fetch entity configuration for {}", (Object)issuer);
        return null;
    }
}

