/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.resolver.CriteriaSet;

@ThreadSafeAfterInit
public class DefaultSubordinateStatementCriteriaToIdentifierStrategy
extends AbstractIdentifiableInitializableComponent
implements Function<CriteriaSet, Pair<String, String>> {
    @NonnullAfterInit
    private Function<CriteriaSet, String> criteriaToSubjectEntityIdStrategy;
    @NonnullAfterInit
    private Function<CriteriaSet, String> criteriaToIssuerEntityIdStrategy;

    public void setCriteriaToSubjectEntityIdStrategy(@Nonnull Function<CriteriaSet, String> strategy) {
        this.checkSetterPreconditions();
        this.criteriaToSubjectEntityIdStrategy = (Function)Constraint.isNotNull(strategy, (String)"Criteria to subject entity ID strategy cannot be null");
    }

    public void setCriteriaToIssuerEntityIdStrategy(@Nonnull Function<CriteriaSet, String> strategy) {
        this.checkSetterPreconditions();
        this.criteriaToIssuerEntityIdStrategy = (Function)Constraint.isNotNull(strategy, (String)"Criteria to issuer entity ID strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.criteriaToSubjectEntityIdStrategy == null) {
            throw new ComponentInitializationException("Criteria to subject entity ID strategy cannot be null");
        }
        if (this.criteriaToIssuerEntityIdStrategy == null) {
            throw new ComponentInitializationException("Criteria to issuer entity ID strategy cannot be null");
        }
    }

    @Override
    @Nullable
    public Pair<String, String> apply(@Nullable CriteriaSet criteria) {
        this.checkComponentActive();
        String subjectEntityId = this.criteriaToSubjectEntityIdStrategy.apply(criteria);
        if (subjectEntityId == null) {
            return null;
        }
        String issuerEntityId = this.criteriaToIssuerEntityIdStrategy.apply(criteria);
        if (issuerEntityId == null) {
            return null;
        }
        return new Pair((Object)issuerEntityId, (Object)subjectEntityId);
    }
}

