/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata;

import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.IssuerEntityStatementCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.SubjectEntityStatementCriterion;
import net.shibboleth.oidc.security.credential.impl.BasicJOSEObjectCredentialResolver;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.security.credential.Credential;
import org.slf4j.Logger;

public class DefaultSubordinateStatementCredentialResolver
extends BasicJOSEObjectCredentialResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultSubordinateStatementCredentialResolver.class);

    protected Iterable<Credential> resolveFromSource(@Nullable CriteriaSet criteriaSet) throws ResolverException {
        if (criteriaSet == null) {
            throw new ResolverException("No criteria set supplied");
        }
        return this.parseJwkSet(criteriaSet).getKeys().stream().filter(Objects::nonNull).map(jwk -> this.buildJWKCredential((JWK)jwk, null)).filter(Objects::nonNull).map(Credential.class::cast).toList();
    }

    @Nonnull
    protected JWKSet parseJwkSet(@Nonnull CriteriaSet criteriaSet) throws ResolverException {
        SubjectEntityStatementCriterion subjectCriterion = (SubjectEntityStatementCriterion)criteriaSet.get(SubjectEntityStatementCriterion.class);
        if (subjectCriterion == null) {
            this.log.debug("No mandatory SubjectEntityStatementCriterion criteria supplied, resolver could not process");
            throw new ResolverException("Credential criteria set did not contain an instance of SubjectEntityStatementCriterion");
        }
        EntityStatement subjectStatement = subjectCriterion.getValue();
        if (subjectStatement.getEntityID().getValue().equals(subjectStatement.getClaimsSet().getIssuer().getValue())) {
            throw new ResolverException("Unexpected contents in the SubjectEntityStatementCriterion: subject matches issuer");
        }
        IssuerEntityStatementCriterion issuerCriterion = (IssuerEntityStatementCriterion)criteriaSet.get(IssuerEntityStatementCriterion.class);
        if (issuerCriterion == null) {
            this.log.debug("No mandatory IssuerEntityStatementCriterion supplied, resolver could not process");
            throw new ResolverException("Credential criteria set did not contain an instance of IssuerEntityStatementCriterion");
        }
        EntityStatement issuerStatement = issuerCriterion.getValue();
        if (!issuerStatement.getEntityID().getValue().equals(subjectStatement.getClaimsSet().getIssuer().getValue())) {
            throw new ResolverException("Credential criteria do not match for subject and issuer");
        }
        if (!issuerStatement.getEntityID().getValue().equals(issuerStatement.getClaimsSet().getIssuer().getValue())) {
            throw new ResolverException("Issuer entity statement is not self signed");
        }
        JWKSet jwks = issuerStatement.getClaimsSet().getJWKSet();
        if (jwks == null || jwks.isEmpty()) {
            throw new ResolverException("Could not parse mandatory jwks");
        }
        return jwks;
    }
}

