/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jwt.SignedJWT;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.messaging.impl.ResolveEntityRequest;
import net.shibboleth.idp.plugin.oidc.op.oidfed.messaging.impl.ResolveEntityResponse;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.LocalKeyContainer;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.ResolveEntityRequestCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.ResolveEntityResponseContainer;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.ResponseContainerExpirationCriterion;
import net.shibboleth.oidc.metadata.cache.MetadataCache;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.URIBuilder;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.HttpClientSecuritySupport;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class DefaultResolveEntityTrustChainFetchingStrategy
extends AbstractIdentifiableInitializableComponent
implements Function<CriteriaSet, ResolveEntityResponseContainer> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultResolveEntityTrustChainFetchingStrategy.class);
    @NonnullAfterInit
    private MetadataCache<Map<String, LocalKeyContainer>> localTrustAnchorsCache;
    @NonnullAfterInit
    protected HttpClient httpClient;
    @Nullable
    private HttpClientSecurityParameters httpClientSecurityParameters;
    @NonnullAfterInit
    private ObjectMapper objectMapper;

    public void setLocalTrustAnchorsCache(@Nonnull MetadataCache<Map<String, LocalKeyContainer>> cache) {
        this.checkSetterPreconditions();
        this.localTrustAnchorsCache = (MetadataCache)Constraint.isNotNull(cache, (String)"Local Trust Anchor cache cannot be null");
    }

    public void setHttpClient(@Nonnull HttpClient client) {
        this.checkSetterPreconditions();
        this.httpClient = (HttpClient)Constraint.isNotNull((Object)client, (String)"HttpClient cannot be null");
    }

    public void setHttpClientSecurityParameters(@Nullable HttpClientSecurityParameters params) {
        this.checkSetterPreconditions();
        this.httpClientSecurityParameters = params;
    }

    public void setObjectMapper(@Nonnull ObjectMapper mapper) {
        this.checkSetterPreconditions();
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"Object mapper cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.localTrustAnchorsCache == null) {
            throw new ComponentInitializationException("Local Trust Anchor cache cannot be null");
        }
        if (this.httpClient == null) {
            throw new ComponentInitializationException("Httpclient cannot be null");
        }
        if (this.objectMapper == null) {
            throw new ComponentInitializationException("Object mapper cannot be null");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public ResolveEntityResponseContainer apply(@Nullable CriteriaSet criteria) {
        URI uri;
        this.checkComponentActive();
        if (criteria == null) {
            return null;
        }
        ResolveEntityRequestCriterion requestCriterion = (ResolveEntityRequestCriterion)criteria.get(ResolveEntityRequestCriterion.class);
        if (requestCriterion == null) {
            this.log.debug("No request criterion given, returning null");
            return null;
        }
        ResponseContainerExpirationCriterion expirationCriterion = (ResponseContainerExpirationCriterion)criteria.get(ResponseContainerExpirationCriterion.class);
        if (expirationCriterion == null) {
            this.log.debug("No expiration criterion given, returning null");
            return null;
        }
        ResolveEntityRequest resolveRequest = requestCriterion.getRequest();
        HttpGet httpRequest = new HttpGet(resolveRequest.getEndpointURI());
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        nvps.add(new BasicNameValuePair("sub", resolveRequest.getSubject()));
        resolveRequest.getTrustAnchors().forEach(trustAnchor -> nvps.add(new BasicNameValuePair("trust_anchor", trustAnchor)));
        resolveRequest.getEntityTypes().forEach(entityType -> nvps.add(new BasicNameValuePair("entity_type", entityType)));
        try {
            uri = new URIBuilder(httpRequest.getUri()).addParameters(nvps).build();
        }
        catch (URISyntaxException e) {
            this.log.error("Could not build endpoint URI for the resolve entity request", (Throwable)e);
            return null;
        }
        this.log.debug("Using URI {} for fetching resolve entity API response", (Object)uri);
        httpRequest.setHeader("Content-Type", (Object)ContentType.APPLICATION_FORM_URLENCODED);
        httpRequest.setUri(uri);
        HttpClientContext httpContext = this.buildHttpContext((ClassicHttpRequest)httpRequest);
        try (ClassicHttpResponse response = this.httpClient.executeOpen(null, (ClassicHttpRequest)httpRequest, (HttpContext)httpContext);){
            String scheme = httpRequest.getUri().getScheme();
            assert (scheme != null);
            HttpClientSecuritySupport.checkTLSCredentialEvaluated((HttpClientContext)httpContext, (String)scheme);
            if (response != null && response.getCode() == 200) {
                SignedJWT responseJwt = SignedJWT.parse((String)EntityUtils.toString((HttpEntity)response.getEntity()));
                ResolveEntityResponse resolveResponse = new ResolveEntityResponse(responseJwt);
                Instant expirationTime = expirationCriterion.getExpirationInstant();
                ResolveEntityResponseContainer resolveEntityResponseContainer2 = new ResolveEntityResponseContainer(resolveResponse, resolveRequest, expirationTime);
                return resolveEntityResponseContainer2;
            }
            this.log.debug("Unable to fetch resolve entity response from URI: {} (HTTP status {})", (Object)uri, response == null ? null : Integer.valueOf(response.getCode()));
            ResolveEntityResponseContainer resolveEntityResponseContainer = null;
            return resolveEntityResponseContainer;
        }
        catch (IOException | URISyntaxException | java.text.ParseException | ParseException e) {
            this.log.debug("Unable to fetch resolve entity response from URI: {}", (Object)uri, (Object)e);
            return null;
        }
    }

    @Nonnull
    protected HttpClientContext buildHttpContext(@Nonnull ClassicHttpRequest request) {
        HttpClientContext clientContext = HttpClientContext.create();
        assert (clientContext != null);
        HttpClientSecuritySupport.marshalSecurityParameters((HttpClientContext)clientContext, (HttpClientSecurityParameters)this.httpClientSecurityParameters, (boolean)false);
        HttpClientSecuritySupport.addDefaultTLSTrustEngineCriteria((HttpClientContext)clientContext, (HttpRequest)request);
        return clientContext;
    }
}

