/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata;

import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.Response;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.text.ParseException;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.messaging.impl.ResolveEntityResponse;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.AbstractTrustEngineSignatureValidationComponent;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.ResolveEntityResponseContainer;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.SubjectEntityIDCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.SubjectEntityStatementCriterion;
import net.shibboleth.oidc.metadata.cache.MetadataCache;
import net.shibboleth.oidc.metadata.cache.MetadataCacheException;
import net.shibboleth.oidc.metadata.filter.MetadataFilterContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class DefaultResolveEntityResponseSignatureValidationFilterStrategy
extends AbstractTrustEngineSignatureValidationComponent
implements BiFunction<ResolveEntityResponseContainer, MetadataFilterContext, ResolveEntityResponseContainer> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultResolveEntityResponseSignatureValidationFilterStrategy.class);
    @NonnullAfterInit
    private MetadataCache<EntityStatement> entityConfigurationCache;

    public void setEntityConfigurationCache(@Nonnull MetadataCache<EntityStatement> cache) {
        this.checkSetterPreconditions();
        this.entityConfigurationCache = (MetadataCache)Constraint.isNotNull(cache, (String)"Entity Configuration cache cannot be null");
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.entityConfigurationCache == null) {
            throw new ComponentInitializationException("Entity Configuration cache cannot be null");
        }
    }

    @Override
    @Nullable
    public ResolveEntityResponseContainer apply(@Nullable ResolveEntityResponseContainer response, @Nullable MetadataFilterContext filterContext) {
        this.checkComponentActive();
        if (response == null) {
            return null;
        }
        Response response2 = response.getResponse();
        if (response2 instanceof ResolveEntityResponse) {
            String entityId;
            ResolveEntityResponse successResponse = (ResolveEntityResponse)response2;
            SignedJWT jwt = successResponse.getJWT();
            try {
                entityId = jwt.getJWTClaimsSet().getIssuer();
            }
            catch (ParseException e) {
                this.log.error("Could not parse issuer entity ID value from the response", (Throwable)e);
                return null;
            }
            EntityStatement issuerStatement = this.fetchIssuerStatement(entityId);
            if (issuerStatement == null) {
                return null;
            }
            this.log.trace("Starting signature validation of success response from {}", (Object)entityId);
            CriteriaSet criteria = new CriteriaSet(new Criterion[]{new SubjectEntityStatementCriterion(issuerStatement)});
            if (this.validateJwt(jwt, criteria, entityId)) {
                return response;
            }
        } else {
            this.log.trace("Ignoring signagure validation for the error response");
            return response;
        }
        return null;
    }

    @Nullable
    protected EntityStatement fetchIssuerStatement(@Nonnull String issuer) {
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{new SubjectEntityIDCriterion(issuer)});
        try {
            List result = this.entityConfigurationCache.get(criteria);
            if (!result.isEmpty()) {
                return (EntityStatement)result.get(0);
            }
        }
        catch (MetadataCacheException e) {
            this.log.debug("Error while fetching issuer entity configuration for {}", (Object)issuer, (Object)e);
        }
        this.log.warn("Could not fetch entity configuration for {}", (Object)issuer);
        return null;
    }
}

