/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata;

import com.nimbusds.oauth2.sdk.Response;
import java.text.ParseException;
import java.time.Instant;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.plugin.oidc.op.oidfed.messaging.impl.ResolveEntityResponse;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.ResolveEntityResponseContainer;
import net.shibboleth.oidc.metadata.cache.ExpirationTimeContext;

@ThreadSafe
public class DefaultResolveEntityResponseContainerExpirationTimeStrategy
implements Function<ExpirationTimeContext<ResolveEntityResponseContainer>, Instant> {
    @Override
    @Nullable
    public Instant apply(@Nullable ExpirationTimeContext<ResolveEntityResponseContainer> context) {
        if (context == null) {
            return null;
        }
        Instant contextExpiration = context.getNow().plus(context.getMaxCacheDuration());
        ResolveEntityResponseContainer container = (ResolveEntityResponseContainer)context.getMetadata();
        if (container == null || container.getExpirationInstant() == null) {
            return contextExpiration;
        }
        Instant containerExpiration = container.getExpirationInstant();
        Response response = container.getResponse();
        if (response instanceof ResolveEntityResponse) {
            ResolveEntityResponse successResponse = (ResolveEntityResponse)response;
            try {
                Instant jwtExpiration = successResponse.getJWT().getJWTClaimsSet().getExpirationTime().toInstant();
                return jwtExpiration.isBefore(containerExpiration) ? jwtExpiration : containerExpiration;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return containerExpiration;
    }
}

