/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.AbstractEntityStatementSignatureValidationComponent;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.IssuerEntityStatementCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.SubjectEntityStatementCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.constraints.FederationPolicyConstraint;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.constraints.FederationPolicyConstraintHelper;
import net.shibboleth.oidc.metadata.filter.MetadataFilterContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class DefaultProvidedTrustChainValidationStrategy
extends AbstractEntityStatementSignatureValidationComponent
implements BiPredicate<ProfileRequestContext, List<EntityStatement>> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultProvidedTrustChainValidationStrategy.class);
    @NonnullAfterInit
    BiFunction<EntityStatement, MetadataFilterContext, EntityStatement> trustAnchorSignatureValidationFilterStrategy;
    @NonnullAfterInit
    private Map<String, FederationPolicyConstraint> federationPolicyConstraints;
    @NonnullAfterInit
    private ObjectMapper objectMapper;

    public void setTrustAnchorSignatureValidationFilterStrategy(@Nonnull BiFunction<EntityStatement, MetadataFilterContext, EntityStatement> strategy) {
        this.checkSetterPreconditions();
        this.trustAnchorSignatureValidationFilterStrategy = (BiFunction)Constraint.isNotNull(strategy, (String)"TrustAnchorSignatureValidationFilterStrategy cannot be null");
    }

    public void setfederationPolicyConstraints(@Nonnull Map<String, FederationPolicyConstraint> constraints) {
        this.checkSetterPreconditions();
        this.federationPolicyConstraints = (Map)Constraint.isNotNull(constraints, (String)"Map of policy constraints cannot be null");
    }

    public void setObjectMapper(@Nonnull ObjectMapper mapper) {
        this.checkSetterPreconditions();
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"Object mapper cannot be null");
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.trustAnchorSignatureValidationFilterStrategy == null) {
            throw new ComponentInitializationException("TrustAnchorSignatureValidationFilterStrategy cannot be null");
        }
        if (this.federationPolicyConstraints == null) {
            throw new ComponentInitializationException("Map of policy constraints cannot be null");
        }
        if (this.objectMapper == null) {
            throw new ComponentInitializationException("Object mapper cannot be null");
        }
    }

    @Override
    public boolean test(@Nullable ProfileRequestContext profileRequestContext, @Nullable List<EntityStatement> trustChain) {
        int i;
        this.checkComponentActive();
        if (trustChain == null || trustChain.size() < 3 || trustChain.contains(null)) {
            this.log.error("No satisfactory trust chain provided");
            return false;
        }
        EntityStatement entityConfiguration = trustChain.get(0);
        assert (entityConfiguration != null);
        if (!this.validateStatement(entityConfiguration, new CriteriaSet(new Criterion[]{new SubjectEntityStatementCriterion(entityConfiguration)}), entityConfiguration.getEntityID().getValue())) {
            this.log.debug("Entity configuration signature validation failed");
            return false;
        }
        for (i = 1; i < trustChain.size() - 2; ++i) {
            EntityStatement subordinateStatement = trustChain.get(i);
            EntityStatement issuerStatement = trustChain.get(i + 1);
            assert (subordinateStatement != null);
            assert (issuerStatement != null);
            CriteriaSet criteria = new CriteriaSet();
            criteria.add((Object)new IssuerEntityStatementCriterion(issuerStatement));
            criteria.add((Object)new SubjectEntityStatementCriterion(subordinateStatement));
            if (this.validateStatement(subordinateStatement, criteria, subordinateStatement.getEntityID().getValue())) continue;
            this.log.debug("Subordinate statement {} signature validation failed", (Object)subordinateStatement.getEntityID());
            return false;
        }
        for (i = 1; i < trustChain.size() - 1; ++i) {
            if (FederationPolicyConstraintHelper.verifyPolicyConstraints(this.objectMapper, trustChain.get(i), trustChain.subList(0, i), this.federationPolicyConstraints)) continue;
            this.log.debug("Subordinate statement {} policy constraints validation failed", (Object)trustChain.get(i).getEntityID());
            return false;
        }
        EntityStatement trustAnchor = trustChain.get(trustChain.size() - 1);
        if (!trustAnchor.equals(this.trustAnchorSignatureValidationFilterStrategy.apply(trustAnchor, null))) {
            this.log.debug("Trust anchor {} validation failed", (Object)trustAnchor.getEntityID());
            return false;
        }
        return true;
    }
}

