/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata;

import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.LocalKeyContainer;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.SubjectEntityStatementCriterion;
import net.shibboleth.oidc.metadata.cache.MetadataCache;
import net.shibboleth.oidc.metadata.cache.MetadataCacheException;
import net.shibboleth.oidc.security.credential.BasicJWKCredential;
import net.shibboleth.oidc.security.credential.impl.BasicJOSEObjectCredentialResolver;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.security.credential.Credential;
import org.slf4j.Logger;

public class DefaultLocalTrustAnchorCredentialResolver
extends BasicJOSEObjectCredentialResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultLocalTrustAnchorCredentialResolver.class);
    @Nonnull
    private MetadataCache<Map<String, LocalKeyContainer>> localTrustAnchorsCache;

    public DefaultLocalTrustAnchorCredentialResolver(@Nonnull @ParameterName(name="cache") MetadataCache<Map<String, LocalKeyContainer>> cache) {
        this.localTrustAnchorsCache = (MetadataCache)Constraint.isNotNull(cache, (String)"Local Trust Anchors cache cannot be null");
    }

    protected Iterable<Credential> resolveFromSource(@Nullable CriteriaSet criteriaSet) throws ResolverException {
        List keyContainers;
        if (criteriaSet == null) {
            throw new ResolverException("No criteria supplied");
        }
        SubjectEntityStatementCriterion subjectCriterion = (SubjectEntityStatementCriterion)criteriaSet.get(SubjectEntityStatementCriterion.class);
        if (subjectCriterion == null) {
            this.log.debug("No SubjectEntityStatementCriterion criteria supplied, resolver could not process");
            throw new ResolverException("Credential criteria set did not contain an instance of SubjectEntityStatementCriterion");
        }
        String entityId = subjectCriterion.getValue().getEntityID().getValue();
        this.log.debug("Attempting to find trusted keys for {}", (Object)entityId);
        try {
            keyContainers = this.localTrustAnchorsCache.get(criteriaSet);
        }
        catch (MetadataCacheException e) {
            throw new ResolverException("Could not resolve local trust anchor keys from the cache", (Exception)((Object)e));
        }
        if (keyContainers.isEmpty() || !((Map)keyContainers.get(0)).containsKey(entityId)) {
            this.log.debug("No keys found for {}", (Object)entityId);
            return CollectionSupport.emptyList();
        }
        LocalKeyContainer keyContainer = (LocalKeyContainer)((Map)keyContainers.get(0)).get(entityId);
        if (keyContainer == null || keyContainer.getJWKSet() == null) {
            this.log.debug("No JWKSet found for {}", (Object)entityId);
            return CollectionSupport.emptyList();
        }
        JWKSet jwkSet = keyContainer.getJWKSet();
        ArrayList<Credential> credentials = new ArrayList<Credential>();
        assert (jwkSet != null);
        for (JWK jwk : jwkSet.getKeys()) {
            BasicJWKCredential cred;
            if (jwk == null || (cred = this.buildJWKCredential(jwk, null)) == null) continue;
            credentials.add((Credential)cred);
        }
        this.log.debug("Returning credentials {} for {}", credentials, (Object)entityId);
        return credentials;
    }
}

