/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.NimbusResponseContainer;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.NimbusResponseCriterion;
import net.shibboleth.idp.plugin.oidc.op.oidfed.metadata.ResponseContainerExpirationCriterion;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class DefaultEntityConfigurationResponseFetchingStrategy
extends AbstractIdentifiableInitializableComponent
implements Function<CriteriaSet, NimbusResponseContainer> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultEntityConfigurationResponseFetchingStrategy.class);

    @Override
    @Nullable
    public NimbusResponseContainer apply(@Nullable CriteriaSet criteria) {
        this.checkComponentActive();
        if (criteria == null) {
            return null;
        }
        NimbusResponseCriterion responseCriterion = (NimbusResponseCriterion)criteria.get(NimbusResponseCriterion.class);
        if (responseCriterion == null) {
            this.log.debug("No response criterion given, returning null");
            return null;
        }
        ResponseContainerExpirationCriterion expirationCriterion = (ResponseContainerExpirationCriterion)criteria.get(ResponseContainerExpirationCriterion.class);
        if (expirationCriterion == null) {
            this.log.debug("No expiration criterion given, returning null");
            return null;
        }
        return new NimbusResponseContainer(responseCriterion.getResponse(), expirationCriterion.getExpirationInstant());
    }
}

