/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.metadata;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.cache.MetadataCache;
import net.shibboleth.oidc.metadata.cache.MetadataCacheException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class DefaultEntityConfigurationMetadataSkeletonLookupStrategy
extends AbstractIdentifiableInitializableComponent
implements Function<CriteriaSet, Map<String, Map<String, Object>>> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultEntityConfigurationMetadataSkeletonLookupStrategy.class);
    @NonnullAfterInit
    private MetadataCache<Map<String, Map<String, Object>>> metadataSkeletonCache;

    public void setMetadataSkeletonCache(@Nonnull MetadataCache<Map<String, Map<String, Object>>> cache) {
        this.checkSetterPreconditions();
        this.metadataSkeletonCache = (MetadataCache)Constraint.isNotNull(cache, (String)"Metadata skeleton cache cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.metadataSkeletonCache == null) {
            throw new ComponentInitializationException("Metadata skeleton cache cannot be null");
        }
    }

    @Override
    @Nullable
    public Map<String, Map<String, Object>> apply(@Nullable CriteriaSet criteria) {
        this.checkComponentActive();
        try {
            return Optional.of(this.metadataSkeletonCache.get(criteria)).filter(result -> result.size() == 1).map(result -> (Map)result.get(0)).orElse(CollectionSupport.emptyMap());
        }
        catch (MetadataCacheException e) {
            this.log.error("Could not fetch metadata skeleton via metadata cache", (Throwable)e);
            return CollectionSupport.emptyMap();
        }
    }
}

