/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.messaging.impl;

import com.nimbusds.common.contenttype.ContentType;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Response;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import javax.annotation.Nonnull;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;

public class ResolveEntityResponse
implements Response {
    @Nonnull
    public static final ContentType CONTENT_TYPE = new ContentType("application", "resolve-response+jwt", new ContentType.Parameter[0]);
    @Nonnull
    private final SignedJWT jwt;

    public ResolveEntityResponse(@Nonnull SignedJWT statement) {
        this.jwt = (SignedJWT)Constraint.isNotNull((Object)statement, (String)"Entity statement cannot be null");
    }

    @Nonnull
    public SignedJWT getJWT() {
        return this.jwt;
    }

    public boolean indicatesSuccess() {
        return true;
    }

    public HTTPResponse toHTTPResponse() {
        HTTPResponse httpResponse = new HTTPResponse(200);
        httpResponse.setEntityContentType(CONTENT_TYPE);
        httpResponse.setContent(this.jwt.serialize());
        return httpResponse;
    }

    @Nonnull
    public static ResolveEntityResponse parse(@Nonnull HTTPResponse httpResponse) throws ParseException {
        httpResponse.ensureStatusCode(new int[]{200});
        httpResponse.ensureEntityContentType(CONTENT_TYPE);
        String content = httpResponse.getContent();
        if (StringSupport.trimOrNull((String)content) == null) {
            throw new ParseException("Message body is empty");
        }
        try {
            SignedJWT jwt = SignedJWT.parse((String)httpResponse.getContent());
            assert (jwt != null);
            return new ResolveEntityResponse(jwt);
        }
        catch (java.text.ParseException e) {
            throw new ParseException(e.getMessage(), (Throwable)e);
        }
    }
}

