/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.messaging.impl;

import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Response;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import javax.annotation.Nonnull;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;

public class ExplicitClientRegistrationResponse
implements Response {
    @Nonnull
    private final EntityStatement entityStatement;

    public ExplicitClientRegistrationResponse(@Nonnull EntityStatement statement) {
        this.entityStatement = (EntityStatement)Constraint.isNotNull((Object)statement, (String)"Entity statement cannot be null");
    }

    @Nonnull
    public EntityStatement getEntityStatement() {
        return this.entityStatement;
    }

    public boolean indicatesSuccess() {
        return true;
    }

    public HTTPResponse toHTTPResponse() {
        HTTPResponse httpResponse = new HTTPResponse(200);
        httpResponse.setEntityContentType(EntityStatement.CONTENT_TYPE);
        httpResponse.setContent(this.entityStatement.getSignedStatement().serialize());
        return httpResponse;
    }

    @Nonnull
    public static ExplicitClientRegistrationResponse parse(@Nonnull HTTPResponse httpResponse) throws ParseException {
        httpResponse.ensureStatusCode(new int[]{200});
        httpResponse.ensureEntityContentType(EntityStatement.CONTENT_TYPE);
        String content = httpResponse.getContent();
        if (StringSupport.trimOrNull((String)content) == null) {
            throw new ParseException("Message body is empty");
        }
        try {
            EntityStatement entityStatement = EntityStatement.parse((SignedJWT)SignedJWT.parse((String)httpResponse.getContent()));
            assert (entityStatement != null);
            return new ExplicitClientRegistrationResponse(entityStatement);
        }
        catch (java.text.ParseException e) {
            throw new ParseException(e.getMessage(), (Throwable)e);
        }
    }
}

