/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.decoding.impl;

import com.nimbusds.oauth2.sdk.Request;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.decoder.servlet.AbstractHttpServletRequestMessageDecoder;
import org.slf4j.Logger;

public abstract class BaseOAuth2RequestDecoder<T extends Request>
extends AbstractHttpServletRequestMessageDecoder {
    @Nonnull
    private static final Logger log = LoggerFactory.getLogger(BaseOAuth2RequestDecoder.class);
    private boolean removeIpAddressFromEndpointUri;

    public BaseOAuth2RequestDecoder() {
        this.setProtocolMessageLoggerSubCategory("OAUTH2");
    }

    public synchronized void setRemoveIpAddressFromEndpointUri(boolean flag) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        this.removeIpAddressFromEndpointUri = flag;
    }

    protected void doDecode() throws MessageDecodingException {
        MessageContext messageContext = new MessageContext();
        HttpServletRequest httpServletRequest = this.getHttpServletRequest();
        assert (httpServletRequest != null);
        T requestMessage = this.parseMessage();
        messageContext.setMessage(requestMessage);
        this.setMessageContext(messageContext);
    }

    @Nullable
    protected abstract T parseMessage() throws MessageDecodingException;

    @Nullable
    protected abstract String getMessageToLog(T var1);

    @Nullable
    protected String serializeMessageForLogging(@Nullable Object message) {
        return this.getMessageToLog((Request)message);
    }

    @Nullable
    protected String getEndpointURI(Request message) {
        if (this.removeIpAddressFromEndpointUri) {
            HttpServletRequest httpServletRequest = this.getHttpServletRequest();
            return httpServletRequest != null ? httpServletRequest.getRequestURI() : null;
        }
        URI endpointUri = message.getEndpointURI();
        return endpointUri != null ? endpointUri.toString() : null;
    }
}

