/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.config;

import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl.RelyingPartyTrustChainContext;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;

public class TrustAnchorIdLookupFunction
implements Function<ProfileRequestContext, String> {
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyTrustChainContext> trustChainContextLookupStrategy;

    public TrustAnchorIdLookupFunction() {
        Function tcls = new ChildContextLookup(RelyingPartyTrustChainContext.class).compose((Function)new InboundMessageContextLookup());
        assert (tcls != null);
        this.trustChainContextLookupStrategy = tcls;
    }

    public TrustAnchorIdLookupFunction(@Nonnull Function<ProfileRequestContext, RelyingPartyTrustChainContext> strategy) {
        this.trustChainContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public String apply(@Nullable ProfileRequestContext profileRequestContext) {
        return Optional.ofNullable(profileRequestContext).map(profileCtx -> this.trustChainContextLookupStrategy.apply((ProfileRequestContext)profileCtx)).map(trustChainCtx -> trustChainCtx.getSelectedTrustChain()).filter(pair -> pair != null && pair.getFirst() != null).map(pair -> (List)pair.getFirst()).filter(list -> !list.isEmpty()).map(chain -> (EntityStatement)chain.get(chain.size() - 1)).map(statement -> statement.getEntityID().getValue()).orElse(null);
    }
}

