/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.config;

import java.time.Duration;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.config.AbstractOIDFederationResponseCachingProfileConfiguration;
import net.shibboleth.idp.plugin.oidc.op.oidfed.config.OIDFederationResolveEntityProfileConfiguration;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.Positive;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class DefaultOIDFederationResolveEntityProfileConfiguration
extends AbstractOIDFederationResponseCachingProfileConfiguration
implements OIDFederationResolveEntityProfileConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROFILE_COUNTER = "net.shibboleth.idp.profiles.oidfed.resolve-entity";
    @Nonnull
    private Function<ProfileRequestContext, String> issuerLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, Duration> cachedErrorResponseLifetimeLookupStrategy = FunctionSupport.constant((Object)Duration.ofMinutes(5L));

    public DefaultOIDFederationResolveEntityProfileConfiguration() {
        this("http://shibboleth.net/ns/profiles/oidfed/resolve-entity");
    }

    public DefaultOIDFederationResolveEntityProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
    }

    @Nullable
    @NotEmpty
    public String getIssuer(@Nullable ProfileRequestContext profileRequestContext) {
        return this.issuerLookupStrategy.apply(profileRequestContext);
    }

    public void setIssuer(@Nullable @NotEmpty String issuer) {
        this.issuerLookupStrategy = FunctionSupport.constant((Object)issuer);
    }

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Issuer lookup strategy cannot be null");
    }

    @Override
    @Nonnull
    @Positive
    public Duration getCachedErrorResponseLifetime(@Nullable ProfileRequestContext profileRequestContext) {
        Duration lifetime = this.cachedErrorResponseLifetimeLookupStrategy.apply(profileRequestContext);
        Constraint.isTrue((lifetime != null && !lifetime.isZero() && !lifetime.isNegative() ? 1 : 0) != 0, (String)"Error response lifetime must be greater than 0");
        assert (lifetime != null);
        return lifetime;
    }

    public void setCachedErrorResponseLifetime(@Nonnull @Positive Duration lifetime) {
        Duration errorLifetime = (Duration)Constraint.isNotNull((Object)lifetime, (String)"Cached error response lifetime cannot be null");
        Constraint.isTrue((!errorLifetime.isZero() && !errorLifetime.isNegative() ? 1 : 0) != 0, (String)"Cached error response lifetime must be greater than 0");
        this.cachedErrorResponseLifetimeLookupStrategy = FunctionSupport.constant((Object)errorLifetime);
    }

    public void setCachedErrorResponseLifetimeLookupStrategy(@Nullable Function<ProfileRequestContext, Duration> strategy) {
        this.cachedErrorResponseLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }
}

