/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.config;

import java.time.Duration;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oidfed.config.OIDFederationResponseCachingProfileConfiguration;
import net.shibboleth.profile.config.AbstractConditionalProfileConfiguration;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.Positive;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public abstract class AbstractOIDFederationResponseCachingProfileConfiguration
extends AbstractConditionalProfileConfiguration
implements OIDFederationResponseCachingProfileConfiguration {
    @Nonnull
    private Function<ProfileRequestContext, Duration> cachedSuccessResponseLifetimeLookupStrategy = FunctionSupport.constant((Object)Duration.ofMinutes(5L));

    public AbstractOIDFederationResponseCachingProfileConfiguration(@Nonnull @ParameterName(name="id") @NotEmpty String id) {
        super(id);
    }

    @Override
    @Nonnull
    @Positive
    public Duration getCachedSuccessResponseLifetime(@Nullable ProfileRequestContext profileRequestContext) {
        Duration lifetime = this.cachedSuccessResponseLifetimeLookupStrategy.apply(profileRequestContext);
        Constraint.isTrue((lifetime != null && !lifetime.isZero() && !lifetime.isNegative() ? 1 : 0) != 0, (String)"Success response lifetime must be greater than 0");
        assert (lifetime != null);
        return lifetime;
    }

    public void setCachedSuccessResponseLifetime(@Nonnull @Positive Duration lifetime) {
        Duration successLifetime = (Duration)Constraint.isNotNull((Object)lifetime, (String)"Cached success response lifetime cannot be null");
        Constraint.isTrue((!successLifetime.isZero() && !successLifetime.isNegative() ? 1 : 0) != 0, (String)"Cached success response lifetime must be greater than 0");
        this.cachedSuccessResponseLifetimeLookupStrategy = FunctionSupport.constant((Object)successLifetime);
    }

    public void setCachedSuccessResponseLifetimeLookupStrategy(@Nullable Function<ProfileRequestContext, Duration> strategy) {
        this.cachedSuccessResponseLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }
}

