/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.attribute.filter.policyrule.impl;

import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.filter.PolicyRequirementRule;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.plugin.oidc.op.oidfed.profile.impl.RelyingPartyTrustChainContext;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.RecursiveTypedParentContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.slf4j.Logger;

public class EntityTrustMarkPolicyRule
extends AbstractIdentifiableInitializableComponent
implements PolicyRequirementRule {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(EntityTrustMarkPolicyRule.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyTrustChainContext> trustChainContextLookupStrategy;
    @Nullable
    private String matchString;
    @Nullable
    private String logPrefix;

    public EntityTrustMarkPolicyRule() {
        Function tcls = new ChildContextLookup(RelyingPartyTrustChainContext.class, false).compose((Function)new InboundMessageContextLookup());
        assert (tcls != null);
        this.trustChainContextLookupStrategy = tcls;
        this.logPrefix = null;
    }

    public void setTrustChainContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyTrustChainContext> strategy) {
        this.checkSetterPreconditions();
        this.trustChainContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"TrustChainContextLookupStrategy cannot be null");
    }

    public void setMatchString(@Nullable String match) {
        this.checkSetterPreconditions();
        this.matchString = match;
    }

    @Nonnull
    protected String getLogPrefix() {
        String prefix = this.logPrefix;
        if (null == prefix) {
            StringBuilder builder = new StringBuilder("Attribute Filter '").append(this.getId()).append("':");
            prefix = builder.toString();
            if (null == this.logPrefix) {
                this.logPrefix = prefix;
            }
        }
        assert (prefix != null);
        return prefix;
    }

    public PolicyRequirementRule.Tristate matches(@Nonnull AttributeFilterContext filterContext) {
        this.checkComponentActive();
        RelyingPartyTrustChainContext trustChainContext = this.trustChainContextLookupStrategy.apply((ProfileRequestContext)new RecursiveTypedParentContextLookup(ProfileRequestContext.class).apply((BaseContext)filterContext));
        if (trustChainContext == null) {
            this.log.debug("{} No RelyingPartyTrustChainContext resolved", (Object)this.getLogPrefix());
            return PolicyRequirementRule.Tristate.FALSE;
        }
        String entityId = Optional.ofNullable(trustChainContext.getSelectedTrustChain()).map(pair -> (List)pair.getFirst()).map(chain -> (EntityStatement)chain.get(0)).map(statement -> statement.getEntityID().getValue()).orElse(null);
        if (entityId == null) {
            this.log.debug("{} Could not resolve entity ID from selected trust chain", (Object)this.getLogPrefix());
            return PolicyRequirementRule.Tristate.FALSE;
        }
        Boolean result = Optional.ofNullable(trustChainContext.getVerifiedTrustMarkIds()).map(map -> (List)map.get(entityId)).map(ids -> ids.contains(this.matchString)).orElse(Boolean.FALSE);
        this.log.debug("{} Returning {}", (Object)this.getLogPrefix(), (Object)result);
        return result != false ? PolicyRequirementRule.Tristate.TRUE : PolicyRequirementRule.Tristate.FALSE;
    }
}

