/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oidfed.tbd;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.AccessTokenResponse;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.ErrorResponse;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Response;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.claims.LogoutTokenClaimsSet;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.messaging.JSONSuccessResponse;

public final class ResponseUtil {
    private ResponseUtil() {
    }

    protected static String toString(@Nullable HTTPResponse httpResponse) {
        return ResponseUtil.toString(httpResponse, null);
    }

    protected static String toString(@Nullable HTTPResponse httpResponse, @Nullable ObjectMapper objectMapper) {
        String rawContent;
        if (httpResponse == null) {
            return null;
        }
        String nl = System.lineSeparator();
        Object ret = nl;
        Map headers = httpResponse.getHeaderMap();
        if (headers != null) {
            ret = (String)ret + "Headers:" + nl;
            for (Map.Entry entry : headers.entrySet()) {
                ret = (String)ret + "\t" + (String)entry.getKey() + ":" + (String)((List)entry.getValue()).get(0) + nl;
            }
        }
        if ((rawContent = httpResponse.getContent()) != null) {
            if (objectMapper != null) {
                try {
                    Object jsonObject = objectMapper.readValue(rawContent, Object.class);
                    String content = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(jsonObject);
                    ret = (String)ret + "Content:" + content.replace("\n", "\n\t");
                    return ret;
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
            }
            ret = (String)ret + "Content:" + rawContent;
        }
        return ret;
    }

    @Nullable
    protected static String toString(@Nullable HttpServletResponse httpServletResponse, @Nullable String content) {
        if (httpServletResponse == null) {
            return null;
        }
        String nl = System.lineSeparator();
        Object ret = nl;
        Collection headerNames = httpServletResponse.getHeaderNames();
        if (headerNames != null) {
            ret = (String)ret + "Headers:" + nl;
            for (String headerName : headerNames) {
                ret = (String)ret + "\t" + headerName + ":" + httpServletResponse.getHeader(headerName) + nl;
            }
        }
        if (content != null) {
            ret = (String)ret + "Content:" + content;
        }
        return ret;
    }

    @Nullable
    public static String getProtocolMessage(@Nullable Response response) {
        if (response == null) {
            return null;
        }
        if (response instanceof JSONSuccessResponse) {
            return ResponseUtil.getProtocolMessageForJSONSuccessResponse(response);
        }
        if (response instanceof ErrorResponse) {
            ErrorResponse genericError = (ErrorResponse)response;
            return MoreObjects.toStringHelper((Object)genericError).omitNullValues().add("errorObject", (Object)genericError.getErrorObject()).toString();
        }
        return MoreObjects.toStringHelper((Object)response).toString();
    }

    @Nullable
    public static String getProtocolMessageForTokenResponse(@Nonnull TokenResponse response) {
        if (response.indicatesSuccess()) {
            AccessTokenResponse successResponse = response.toSuccessResponse();
            return MoreObjects.toStringHelper((Object)successResponse).omitNullValues().add("customParameters", (Object)successResponse.getCustomParameters()).add("tokens", (Object)successResponse.getTokens()).toString();
        }
        TokenErrorResponse errorResponse = response.toErrorResponse();
        return MoreObjects.toStringHelper((Object)errorResponse).omitNullValues().add("errorObject", (Object)ResponseUtil.getProtocolMessageForErrorObject(errorResponse.getErrorObject())).toString();
    }

    @Nullable
    public static String getProtocolMessageForErrorObject(@Nullable ErrorObject errorObject) {
        return errorObject == null ? null : MoreObjects.toStringHelper((Object)errorObject).omitNullValues().add("httpStatusCode", errorObject.getHTTPStatusCode()).add("code", (Object)errorObject.getCode()).add("description", (Object)errorObject.getDescription()).add("uri", (Object)errorObject.getURI()).toString();
    }

    @Nullable
    public static String getProtocolMessageForJSONSuccessResponse(@Nonnull Response response) {
        if (response instanceof JSONSuccessResponse) {
            JSONSuccessResponse successResponse = (JSONSuccessResponse)response;
            return successResponse.toString();
        }
        return null;
    }

    @Nonnull
    public static String getJwtProtocolMessage(@Nonnull JWT jwt, @Nonnull ObjectMapper objectMapper) throws java.text.ParseException {
        return ResponseUtil.getJwtProtocolMessage(jwt.getJWTClaimsSet(), objectMapper);
    }

    @Nonnull
    public static String getIdTokenProtocolMessage(@Nonnull IDTokenClaimsSet idToken, @Nonnull ObjectMapper objectMapper) throws java.text.ParseException {
        try {
            return ResponseUtil.getJwtProtocolMessage(idToken.toJWTClaimsSet(), objectMapper);
        }
        catch (ParseException e) {
            Throwable cause = e.getCause();
            if (cause instanceof java.text.ParseException) {
                java.text.ParseException parseException = (java.text.ParseException)cause;
                throw parseException;
            }
            throw new java.text.ParseException(e.getMessage(), 0);
        }
    }

    @Nonnull
    public static String getLogoutTokenProtocolMessage(@Nonnull LogoutTokenClaimsSet logoutToken, @Nonnull ObjectMapper objectMapper) throws java.text.ParseException {
        try {
            return ResponseUtil.getJwtProtocolMessage(logoutToken.toJWTClaimsSet(), objectMapper);
        }
        catch (ParseException e) {
            Throwable cause = e.getCause();
            if (cause instanceof java.text.ParseException) {
                java.text.ParseException parseException = (java.text.ParseException)cause;
                throw parseException;
            }
            throw new java.text.ParseException(e.getMessage(), 0);
        }
    }

    @Nonnull
    public static String getJwtProtocolMessage(@Nullable JWTClaimsSet claimsSet, @Nonnull ObjectMapper objectMapper) throws java.text.ParseException {
        if (claimsSet == null) {
            return "<encrypted>";
        }
        try {
            Object jsonObject = objectMapper.readValue(claimsSet.toString(), Object.class);
            String content = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(jsonObject);
            if (content != null) {
                return content;
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        throw new java.text.ParseException("Could not parse the JSON output from the claims set", 0);
    }
}

