/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.security.jwt.claims.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.jwt.claims.AbstractClaimsValidator;
import net.shibboleth.oidc.jwt.claims.JWTValidationException;
import org.opensaml.profile.context.ProfileRequestContext;

public class TokenRevocationConditionValidator
extends AbstractClaimsValidator {
    @Nullable
    private BiPredicate<ProfileRequestContext, JWTClaimsSet> tokenRevocationCondition;

    public void setTokenRevocationCondition(@Nullable BiPredicate<ProfileRequestContext, JWTClaimsSet> condition) {
        this.checkSetterPreconditions();
        this.tokenRevocationCondition = condition;
    }

    protected void doValidate(@Nonnull JWTClaimsSet claims, @Nullable ProfileRequestContext profileRequestContext) throws JWTValidationException {
        if (this.tokenRevocationCondition != null && this.tokenRevocationCondition.test(profileRequestContext, claims)) {
            throw new JWTValidationException("Token " + claims.getJWTID() + " for subject '" + claims.getSubject() + "' has been revoked");
        }
    }
}

