/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.security.jwt.claims.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import javax.annotation.Nonnull;
import net.shibboleth.oidc.jwt.claims.AbstractClaimsValidator;
import net.shibboleth.oidc.jwt.claims.JWTValidationException;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

@ThreadSafeAfterInit
public class ChainExpiryClaimsValidator
extends AbstractClaimsValidator {
    @Nonnull
    private Duration clockSkew;

    public ChainExpiryClaimsValidator() {
        Duration skew = Duration.ofSeconds(60L);
        assert (skew != null);
        this.clockSkew = skew;
    }

    public void setClockSkew(@Nonnull Duration skew) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        Duration newValue = ((Duration)Constraint.isNotNull((Object)skew, (String)"Clock skew cannot be null")).abs();
        assert (newValue != null);
        this.clockSkew = newValue;
    }

    public void doValidate(@Nonnull JWTClaimsSet claims, @Nonnull ProfileRequestContext context) throws JWTValidationException {
        Instant expInstant;
        Instant expirationPlusSkew;
        Date exp;
        Instant now = Instant.now();
        try {
            exp = claims.getDateClaim("c_exp");
        }
        catch (ParseException e) {
            throw new JWTValidationException("Unexpected contents on 'c_exp' claim");
        }
        if (exp != null && now.isAfter(expirationPlusSkew = (expInstant = exp.toInstant()).plus(this.clockSkew))) {
            throw new JWTValidationException("Expired JWT by the chain expiration");
        }
    }
}

