/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.logic;

import com.nimbusds.oauth2.sdk.Scope;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.oidc.metadata.policy.UnregisteredClientPolicy;
import net.shibboleth.oidc.metadata.policy.impl.DefaultMetadataPolicyEnforcer;
import net.shibboleth.oidc.profile.config.navigate.UnregisteredClientPolicyLookupFunction;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

public class DefaultUnregisteredClientAllowedScopeLookupFunction
implements Function<ProfileRequestContext, Scope> {
    @Nonnull
    private Function<ProfileRequestContext, Map<String, UnregisteredClientPolicy>> unregisteredClientPolicyLookupStrategy = new UnregisteredClientPolicyLookupFunction();
    @Nonnull
    private BiFunction<Object, MetadataPolicy, Pair<Object, Boolean>> unregisteredClientPolicyEnforcer = new DefaultMetadataPolicyEnforcer();

    public void setUnregisteredClientPolicyLookupStrategy(Function<ProfileRequestContext, Map<String, UnregisteredClientPolicy>> strategy) {
        this.unregisteredClientPolicyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Unregistered client policy lookup strategy cannot be null");
    }

    public void setUnregisteredClientPolicyEnforcer(BiFunction<Object, MetadataPolicy, Pair<Object, Boolean>> enforcer) {
        this.unregisteredClientPolicyEnforcer = (BiFunction)Constraint.isNotNull(enforcer, (String)"Unregistered client policy cannot be null");
    }

    @Override
    @Nonnull
    public Scope apply(@Nullable ProfileRequestContext input) {
        Map<String, UnregisteredClientPolicy> policies = this.unregisteredClientPolicyLookupStrategy.apply(input);
        if (policies == null || policies.isEmpty()) {
            return new Scope();
        }
        Scope scope = Optional.ofNullable((MetadataPolicy)policies.get("scope")).map(policy -> this.unregisteredClientPolicyEnforcer.apply(null, (MetadataPolicy)policy)).filter(value -> value != null).filter(value -> (Boolean)value.getSecond()).map(value -> value.getFirst()).filter(value -> value != null).map(value -> value.toString()).map(Scope::parse).orElse(new Scope());
        return scope == null ? new Scope() : scope;
    }
}

