/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.logic;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.profile.logic.AbstractPushedAuthorizationRequestComponent;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.security.DataSealer;
import net.shibboleth.shared.security.DataSealerException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.ReplayCache;
import org.slf4j.Logger;

public class DefaultPushedAuthorizationRequestUriDeserializationFunction
extends AbstractPushedAuthorizationRequestComponent
implements BiFunction<ProfileRequestContext, URI, Map<String, Object>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultPushedAuthorizationRequestUriDeserializationFunction.class);
    @NonnullAfterInit
    private DataSealer dataSealer;
    @NonnullAfterInit
    private ObjectMapper objectMapper;
    @NonnullAfterInit
    private ReplayCache replayCache;
    @Nonnull
    private Duration lifetime;

    public DefaultPushedAuthorizationRequestUriDeserializationFunction() {
        Duration fiveMins = Duration.ofMinutes(5L);
        assert (fiveMins != null);
        this.lifetime = fiveMins;
    }

    public void setDataSealer(@Nonnull DataSealer sealer) {
        this.checkSetterPreconditions();
        this.dataSealer = (DataSealer)Constraint.isNotNull((Object)sealer, (String)"Data sealer cannot be null");
    }

    public void setObjectMapper(@Nonnull ObjectMapper mapper) {
        this.checkSetterPreconditions();
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"Object mapper cannot be null");
    }

    public void setReplayCache(@Nonnull ReplayCache cache) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.replayCache = (ReplayCache)Constraint.isNotNull((Object)cache, (String)"ReplayCache cannot be null");
    }

    public void setLifetime(@Nonnull Duration duration) {
        this.checkSetterPreconditions();
        this.lifetime = (Duration)Constraint.isNotNull((Object)duration, (String)"Lifetime cannot be null");
        Constraint.isTrue((!this.lifetime.isZero() && !this.lifetime.isNegative() ? 1 : 0) != 0, (String)"Lifetime must be greater than 0");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.dataSealer == null) {
            throw new ComponentInitializationException("Data sealer cannot be null");
        }
        if (this.objectMapper == null) {
            throw new ComponentInitializationException("Object mapper cannot be null");
        }
        if (this.replayCache == null) {
            throw new ComponentInitializationException("Replay cache cannot be null");
        }
    }

    @Override
    @Nullable
    public Map<String, Object> apply(@Nullable ProfileRequestContext profileRequestContext, @Nullable URI uri) {
        if (uri != null) {
            String sealedValue = uri.toString().replace("urn:ietf:params:oauth:request_uri:", "");
            assert (sealedValue != null);
            try {
                String unsealedValue = this.dataSealer.unwrap(sealedValue);
                Map result = (Map)this.objectMapper.readValue(unsealedValue, (TypeReference)new TypeReference<LinkedHashMap<String, Object>>(){});
                String jti = StringSupport.trimOrNull((String)((String)result.get("jti")));
                if (jti == null) {
                    this.log.error("No token identifier (jti) found from the claims set");
                    return null;
                }
                String cacheContext = this.getClass().getName();
                assert (cacheContext != null);
                Instant expiration = Instant.now().plus(this.lifetime);
                assert (expiration != null);
                if (!this.replayCache.check(cacheContext, jti, expiration)) {
                    this.log.warn("Replay detected for request_uri {}", (Object)uri.toString());
                    return null;
                }
                return result;
            }
            catch (DataSealerException e) {
                this.log.debug("Could not decrypt the contents of the request_uri {}", (Object)uri.toString(), (Object)e);
                return null;
            }
            catch (JsonProcessingException e) {
                this.log.error("Could not deserialize the unsealed contents of the request_uri {}", (Object)uri.toString(), (Object)e);
                return null;
            }
        }
        this.log.error("Request URI content set is null");
        return null;
    }
}

