/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.logic;

import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.TokenRequest;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.config.logic.LimitInitialAccessTokenToSelfPredicate;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

public class DefaultEnforceSelfAudienceCondition
implements Predicate<ProfileRequestContext> {
    @Nonnull
    private Predicate<ProfileRequestContext> limitInitialAccessTokenToSelfPredicate;

    public DefaultEnforceSelfAudienceCondition() {
        this((Predicate<ProfileRequestContext>)new LimitInitialAccessTokenToSelfPredicate());
    }

    public DefaultEnforceSelfAudienceCondition(@Nonnull @ParameterName(name="limitInitialAccessTokenToSelfPredicate") Predicate<ProfileRequestContext> condition) {
        this.limitInitialAccessTokenToSelfPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Self initial access token predicate cannot be null");
    }

    @Override
    public boolean test(@Nullable ProfileRequestContext profileRequestContext) {
        if (this.limitInitialAccessTokenToSelfPredicate.test(profileRequestContext)) {
            assert (profileRequestContext != null);
            if (profileRequestContext.getInboundMessageContext() == null) {
                return false;
            }
            Object object = profileRequestContext.ensureInboundMessageContext().getMessage();
            if (object instanceof TokenRequest) {
                TokenRequest tokenRequest = (TokenRequest)object;
                return GrantType.AUTHORIZATION_CODE.equals((Object)tokenRequest.getAuthorizationGrant().getType());
            }
        }
        return false;
    }
}

