/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.logic;

import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.PushedAuthorizationRequest;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;

public class DefaultAuthorizationRequestTypeValidationStrategy
implements Predicate<ProfileRequestContext> {
    @Nonnull
    private Predicate<ProfileRequestContext> requireAuthenticationRequest = PredicateSupport.alwaysTrue();

    public void setRequireAuthenticationRequestPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.requireAuthenticationRequest = (Predicate)Constraint.isNotNull(predicate, (String)"Require authentication request predicate cannot be null");
    }

    @Override
    public boolean test(@Nullable ProfileRequestContext input) {
        if (input == null) {
            return false;
        }
        MessageContext messageContext = input.getInboundMessageContext();
        if (messageContext == null || messageContext.getMessage() == null) {
            return false;
        }
        Object message = messageContext.getMessage();
        if (message instanceof AuthorizationRequest) {
            AuthorizationRequest authorizationRequest = (AuthorizationRequest)message;
            return this.applyPredicate(input, authorizationRequest);
        }
        if (message instanceof PushedAuthorizationRequest) {
            PushedAuthorizationRequest pushedAuthorizationRequest = (PushedAuthorizationRequest)message;
            AuthorizationRequest authorizationRequest = pushedAuthorizationRequest.getAuthorizationRequest();
            assert (authorizationRequest != null);
            return this.applyPredicate(input, authorizationRequest);
        }
        return false;
    }

    protected boolean applyPredicate(@Nullable ProfileRequestContext input, @Nonnull AuthorizationRequest request) {
        if (this.requireAuthenticationRequest.test(input)) {
            return request instanceof AuthenticationRequest;
        }
        return true;
    }
}

