/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientRegistrationRequest;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONObject;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCClientRegistrationMetadataPolicyContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.oidc.metadata.policy.impl.DefaultMetadataPolicyEnforcer;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ValidateRegistrationRequestMetadata
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateRegistrationRequestMetadata.class);
    @Nonnull
    private Function<MessageContext, OIDCClientRegistrationMetadataPolicyContext> registrationMetadataPolicyContextLookupStrategy = new ChildContextLookup(OIDCClientRegistrationMetadataPolicyContext.class);
    @Nonnull
    private BiFunction<Object, MetadataPolicy, Pair<Object, Boolean>> metadataPolicyEnforcer = new DefaultMetadataPolicyEnforcer();
    @Nullable
    private OIDCClientRegistrationRequest request;
    @Nullable
    private OIDCClientRegistrationMetadataPolicyContext registrationMetadataPolicyContext;
    @Nullable
    private Map<String, MetadataPolicy> metadataPolicy;

    public void setRegistrationMetadataPolicyContextLookupStrategy(@Nonnull Function<MessageContext, OIDCClientRegistrationMetadataPolicyContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.registrationMetadataPolicyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Registration metadata policy context lookup strategy cannot be null");
    }

    public void setMetadataPolicyEnforcer(@Nonnull BiFunction<Object, MetadataPolicy, Pair<Object, Boolean>> function) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.metadataPolicyEnforcer = (BiFunction)Constraint.isNotNull(function, (String)"The metadata policy enforcer cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        MessageContext messageContext = profileRequestContext.getInboundMessageContext();
        if (messageContext == null) {
            this.log.debug("{} No inbound message context associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        Object message = messageContext.getMessage();
        if (message == null || !(message instanceof OIDCClientRegistrationRequest)) {
            this.log.debug("{} No inbound message associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.request = (OIDCClientRegistrationRequest)message;
        this.registrationMetadataPolicyContext = this.registrationMetadataPolicyContextLookupStrategy.apply(messageContext);
        if (this.registrationMetadataPolicyContext == null) {
            this.log.debug("{} No metadata policy context associated with this request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        assert (this.registrationMetadataPolicyContext != null);
        this.metadataPolicy = this.registrationMetadataPolicyContext.getMetadataPolicy();
        if (this.metadataPolicy == null) {
            this.log.debug("{} No metadata policy associated with this request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        assert (this.metadataPolicy != null);
        Map<String, MetadataPolicy> nonNullPolicy = this.metadataPolicy;
        if (nonNullPolicy.isEmpty()) {
            this.log.debug("{} No metadata policy content found, setting the request as policy enforced", (Object)this.getLogPrefix());
            assert (this.request != null);
            OIDCClientMetadata metadata = this.request.getOIDCClientMetadata();
            assert (metadata != null);
            assert (this.registrationMetadataPolicyContext != null);
            this.registrationMetadataPolicyContext.setPolicyEnforcedMetadata(metadata);
            return;
        }
        this.log.debug("{} Metadata policy used for request validation: {}", (Object)this.getLogPrefix(), this.metadataPolicy);
        boolean compliant = true;
        assert (this.request != null);
        JSONObject requestMetadata = this.request.getOIDCClientMetadata().toJSONObject();
        for (String claim : nonNullPolicy.keySet()) {
            Boolean enforcerResult;
            MetadataPolicy policy = nonNullPolicy.get(claim);
            Object value = requestMetadata.get((Object)claim);
            this.log.debug("{} Claim {} set in policy included in the request: {}", new Object[]{this.getLogPrefix(), claim, value == null});
            Pair<Object, Boolean> result = this.metadataPolicyEnforcer.apply(value, policy);
            Boolean bl = enforcerResult = result != null ? (Boolean)result.getSecond() : null;
            if (enforcerResult == null || !enforcerResult.booleanValue()) {
                this.log.warn("{} Metadata claim {} is not compliant with the policy", (Object)this.getLogPrefix(), (Object)claim);
                compliant = false;
                continue;
            }
            this.log.trace("{} Validation result is OK for claim {}", (Object)this.getLogPrefix(), (Object)claim);
            Object enforcedValue = result != null ? result.getFirst() : null;
            requestMetadata.put((Object)claim, enforcedValue);
        }
        if (!compliant) {
            this.log.warn("{} The requested metadata is not compliant with the policy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
        }
        try {
            OIDCClientMetadata enforcedMetadata = OIDCClientMetadata.parse((JSONObject)requestMetadata);
            assert (enforcedMetadata != null);
            assert (this.registrationMetadataPolicyContext != null);
            this.registrationMetadataPolicyContext.setPolicyEnforcedMetadata(enforcedMetadata);
            this.log.debug("{} The enforced metadata stored in context", (Object)this.getLogPrefix());
        }
        catch (ParseException e) {
            this.log.error("{} Could not parse the enforced metadata", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
        }
    }
}

