/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONObject;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.AttributesMapContainer;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoder;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoderRegistry;
import net.shibboleth.idp.attribute.transcoding.TranscoderSupport;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseTokenClaimsContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCResponseAction;
import net.shibboleth.oidc.profile.config.navigate.AlwaysIncludedAttributesLookupFunction;
import net.shibboleth.oidc.profile.config.navigate.DeniedUserInfoAttributesLookupFunction;
import net.shibboleth.oidc.profile.config.navigate.EncodedAttributesLookupFunction;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.service.ReloadableService;
import net.shibboleth.shared.service.ServiceableComponent;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class SetTokenDeliveryAttributesToResponseContext
extends AbstractOIDCResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SetTokenDeliveryAttributesToResponseContext.class);
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> encodedAttributesLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> alwaysIncludedAttributesLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> deniedUserInfoAttributesLookupStrategy;
    @NonnullAfterInit
    private ReloadableService<AttributeTranscoderRegistry> transcoderRegistry;
    private boolean ignoringUnencodableAttributes;
    @Nullable
    private AttributeContext attributeCtx;
    @Nullable
    @NonnullElements
    private Set<String> encodedAttributes;
    @Nullable
    @NonnullElements
    private Set<String> alwaysIncludedAttributes;
    @Nullable
    @NonnullElements
    private Set<String> deniedUserInfoAttributes;

    SetTokenDeliveryAttributesToResponseContext() {
        Function acls = new ChildContextLookup(AttributeContext.class).compose((Function)new ChildContextLookup(RelyingPartyContext.class));
        assert (acls != null);
        this.attributeContextLookupStrategy = acls;
        this.encodedAttributesLookupStrategy = new EncodedAttributesLookupFunction();
        this.alwaysIncludedAttributesLookupStrategy = new AlwaysIncludedAttributesLookupFunction();
        this.deniedUserInfoAttributesLookupStrategy = new DeniedUserInfoAttributesLookupFunction();
        this.ignoringUnencodableAttributes = true;
    }

    public void setTranscoderRegistry(@Nonnull ReloadableService<AttributeTranscoderRegistry> registry) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.transcoderRegistry = (ReloadableService)Constraint.isNotNull(registry, (String)"AttributeTranscoderRegistry cannot be null");
    }

    public void setIgnoringUnencodableAttributes(boolean flag) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.ignoringUnencodableAttributes = flag;
    }

    public void setAttributeContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.attributeContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext lookup strategy cannot be null");
    }

    public void setEncodedAttributesLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.encodedAttributesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Encoded attributes lookup strategy cannot be null");
    }

    public void setAlwaysIncludedAttributesLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.alwaysIncludedAttributesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Always included ID token attributes lookup strategy cannot be null");
    }

    public void setDeniedUserInfoAttributesLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.deniedUserInfoAttributesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Denied UserInfo attributes lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.transcoderRegistry == null) {
            throw new ComponentInitializationException("AttributeTranscoderRegistry cannot be null");
        }
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.attributeCtx = this.attributeContextLookupStrategy.apply(profileRequestContext);
        if (this.attributeCtx == null) {
            this.log.debug("{} No AttributeSubcontext available, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        this.encodedAttributes = this.encodedAttributesLookupStrategy.apply(profileRequestContext);
        if (this.encodedAttributes == null) {
            this.encodedAttributes = Collections.emptySet();
        }
        this.alwaysIncludedAttributes = this.alwaysIncludedAttributesLookupStrategy.apply(profileRequestContext);
        if (this.alwaysIncludedAttributes == null) {
            this.alwaysIncludedAttributes = Collections.emptySet();
        }
        this.deniedUserInfoAttributes = this.deniedUserInfoAttributesLookupStrategy.apply(profileRequestContext);
        if (this.deniedUserInfoAttributes == null) {
            this.deniedUserInfoAttributes = Collections.emptySet();
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        try (ServiceableComponent component = this.transcoderRegistry.getServiceableComponent();){
            assert (this.attributeCtx != null);
            for (IdPAttribute attribute : this.attributeCtx.getIdPAttributes().values()) {
                if (attribute == null || attribute.getValues().isEmpty()) continue;
                assert (this.encodedAttributes != null);
                if (!this.encodedAttributes.contains(attribute.getId())) continue;
                this.encodeAttribute((AttributeTranscoderRegistry)component.getComponent(), profileRequestContext, attribute);
            }
        }
        catch (AttributeEncodingException e) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToEncodeAttribute");
            return;
        }
    }

    private void encodeAttribute(@Nonnull AttributeTranscoderRegistry registry, @Nonnull ProfileRequestContext profileRequestContext, @Nonnull IdPAttribute attribute) throws AttributeEncodingException {
        OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
        assert (oidcResponseContext != null);
        Collection transcodingRules = registry.getTranscodingRules(attribute, JSONObject.class);
        if (transcodingRules.isEmpty()) {
            this.log.debug("{} Attribute {} does not have any transcoding rules, nothing to do", (Object)this.getLogPrefix(), (Object)attribute.getId());
            return;
        }
        OIDCAuthenticationResponseTokenClaimsContext tokenClaimsCtx = (OIDCAuthenticationResponseTokenClaimsContext)oidcResponseContext.ensureSubcontext(OIDCAuthenticationResponseTokenClaimsContext.class);
        AttributesMapContainer requestedToIdTokenContainer = oidcResponseContext.getMappedIdTokenRequestedClaims();
        for (TranscodingRule rule : transcodingRules) {
            assert (rule != null);
            try {
                JSONObject encodedAttribute;
                boolean requestedToIdToken;
                AttributeTranscoder transcoder = TranscoderSupport.getTranscoder((TranscodingRule)rule);
                boolean bl = requestedToIdToken = requestedToIdTokenContainer != null && requestedToIdTokenContainer.get().containsKey((Object)attribute.getId());
                assert (this.alwaysIncludedAttributes != null);
                boolean alwaysIncluded = this.alwaysIncludedAttributes.contains(attribute.getId());
                assert (this.deniedUserInfoAttributes != null);
                boolean userInfoDenied = this.deniedUserInfoAttributes.contains(attribute.getId());
                if (alwaysIncluded && !userInfoDenied) {
                    encodedAttribute = (JSONObject)transcoder.encode(profileRequestContext, attribute, JSONObject.class, rule);
                    if (encodedAttribute == null) continue;
                    encodedAttribute.keySet().forEach(k -> tokenClaimsCtx.getClaims().setClaim(k, encodedAttribute.get(k)));
                    continue;
                }
                if (alwaysIncluded) {
                    encodedAttribute = (JSONObject)transcoder.encode(profileRequestContext, attribute, JSONObject.class, rule);
                    if (encodedAttribute == null) continue;
                    encodedAttribute.keySet().forEach(k -> tokenClaimsCtx.getIdtokenClaims().setClaim(k, encodedAttribute.get(k)));
                    continue;
                }
                if (!userInfoDenied) {
                    encodedAttribute = (JSONObject)transcoder.encode(profileRequestContext, attribute, JSONObject.class, rule);
                    if (encodedAttribute == null) continue;
                    if (requestedToIdToken) {
                        encodedAttribute.keySet().forEach(k -> tokenClaimsCtx.getClaims().setClaim(k, encodedAttribute.get(k)));
                        continue;
                    }
                    encodedAttribute.keySet().forEach(k -> tokenClaimsCtx.getUserinfoClaims().setClaim(k, encodedAttribute.get(k)));
                    continue;
                }
                if (!requestedToIdToken || (encodedAttribute = (JSONObject)transcoder.encode(profileRequestContext, attribute, JSONObject.class, rule)) == null) continue;
                encodedAttribute.keySet().forEach(k -> tokenClaimsCtx.getIdtokenClaims().setClaim(k, encodedAttribute.get(k)));
            }
            catch (AttributeEncodingException e) {
                this.log.warn("{} Unable to encode attribute {}", new Object[]{this.getLogPrefix(), attribute.getId(), e});
                if (this.ignoringUnencodableAttributes) continue;
                throw e;
            }
        }
    }
}

