/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.RefreshTokenClaimsSetDecorator;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCResponseAction;
import net.shibboleth.idp.plugin.oidc.op.profile.logic.DefaultTokenRevocationLifetimeLookupStrategy;
import net.shibboleth.idp.plugin.oidc.op.storage.RevocationCacheContexts;
import net.shibboleth.idp.plugin.oidc.op.token.support.AuthorizeCodeClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.RefreshTokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.oidc.profile.config.logic.EnforceRefreshTokenRotationPredicate;
import net.shibboleth.oidc.profile.config.navigate.RefreshTokenChainLifetimeLookupFunction;
import net.shibboleth.oidc.profile.config.navigate.RefreshTokenClaimsSetManipulationStrategyLookupFunction;
import net.shibboleth.oidc.profile.config.navigate.RefreshTokenTimeoutLookupFunction;
import net.shibboleth.oidc.profile.config.navigate.RefreshTokenTypeLookupFunction;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.security.DataSealer;
import net.shibboleth.shared.security.DataSealerException;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import net.shibboleth.shared.security.impl.SecureRandomIdentifierGenerationStrategy;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.RevocationCache;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class SetRefreshTokenToResponseContext
extends AbstractOIDCResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SetRefreshTokenToResponseContext.class);
    @Nonnull
    private final DataSealer dataSealer;
    @NonnullAfterInit
    private RevocationCache revocationCache;
    @Nonnull
    private Function<ProfileRequestContext, Duration> refreshTokenChainLifetimeLookupStrategy = new RefreshTokenChainLifetimeLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, Duration> refreshTokenTimeoutLookupStrategy = new RefreshTokenTimeoutLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> tokenClaimsSetManipulationStrategyLookupStrategy;
    @Nullable
    private BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>> manipulationStrategy;
    @Nonnull
    private Collection<RefreshTokenClaimsSetDecorator> tokenClaimsSetDecorators;
    @Nonnull
    private Function<ProfileRequestContext, IdentifierGenerationStrategy> idGeneratorLookupStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> enforceRefreshTokenRotationCondition;
    @Nonnull
    private Function<JWTClaimsSet, Duration> tokenRevocationLifetimeLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> refreshTokenTypeLookupStrategy;
    @Nonnull
    private Map<String, BiFunction<ProfileRequestContext, RefreshTokenClaimsSet, String>> refreshTokenSerializationStrategies;
    @Nullable
    private TokenClaimsSet tokenClaimsSet;
    @Nullable
    private Duration refreshTokenChainLifetime;
    @Nullable
    private Duration refreshTokenTimeout;
    @Nullable
    private IdentifierGenerationStrategy idGenerator;
    @Nullable
    private String refreshTokenType;
    private boolean xmlSafeIdentifier;

    @Autowired
    public SetRefreshTokenToResponseContext(@Nonnull @ParameterName(name="sealer") DataSealer sealer, @Nullable Collection<RefreshTokenClaimsSetDecorator> freeDecorators) {
        this.dataSealer = (DataSealer)Constraint.isNotNull((Object)sealer, (String)"DataSealer cannot be null");
        this.tokenClaimsSetManipulationStrategyLookupStrategy = new RefreshTokenClaimsSetManipulationStrategyLookupFunction();
        this.idGeneratorLookupStrategy = FunctionSupport.constant((Object)new SecureRandomIdentifierGenerationStrategy());
        this.enforceRefreshTokenRotationCondition = new EnforceRefreshTokenRotationPredicate();
        this.tokenRevocationLifetimeLookupStrategy = new DefaultTokenRevocationLifetimeLookupStrategy();
        this.refreshTokenTypeLookupStrategy = new RefreshTokenTypeLookupFunction();
        this.refreshTokenSerializationStrategies = CollectionSupport.emptyMap();
        this.xmlSafeIdentifier = true;
        this.tokenClaimsSetDecorators = freeDecorators == null ? CollectionSupport.emptyList() : freeDecorators;
    }

    public void setRevocationCache(@Nonnull RevocationCache cache) {
        this.checkSetterPreconditions();
        this.revocationCache = (RevocationCache)Constraint.isNotNull((Object)cache, (String)"RevocationCache cannot be null");
    }

    public void setRefreshTokenChainLifetimeLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.checkSetterPreconditions();
        this.refreshTokenChainLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Refresh token chain lifetime lookup strategy cannot be null");
    }

    public void setRefreshTokenTimeoutLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.checkSetterPreconditions();
        this.refreshTokenTimeoutLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Refresh token timeout lookup strategy cannot be null");
    }

    public void setTokenClaimsSetManipulationStrategyLookupStrategy(@Nonnull Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> strategy) {
        this.checkSetterPreconditions();
        this.tokenClaimsSetManipulationStrategyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Manipulation strategy lookup strategy cannot be null");
    }

    public void setIdentifierGeneratorLookupStrategy(@Nonnull Function<ProfileRequestContext, IdentifierGenerationStrategy> strategy) {
        this.checkSetterPreconditions();
        this.idGeneratorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Identifier generation strategy cannot be null");
    }

    public void setEnforceRefreshTokenRotationCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.checkSetterPreconditions();
        this.enforceRefreshTokenRotationCondition = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    public void setTokenRevocationLifetimeLookupStrategy(@Nullable Function<JWTClaimsSet, Duration> strategy) {
        this.checkSetterPreconditions();
        this.tokenRevocationLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public void setRefreshTokenTypeLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.refreshTokenTypeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public void setRefreshTokenSerializationStrategies(@Nonnull Map<String, BiFunction<ProfileRequestContext, RefreshTokenClaimsSet, String>> strategies) {
        this.checkSetterPreconditions();
        this.refreshTokenSerializationStrategies = (Map)Constraint.isNotNull(strategies, (String)"Strategies cannot be null");
    }

    public void setXmlSafeIdentifier(boolean flag) {
        this.checkSetterPreconditions();
        this.xmlSafeIdentifier = flag;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.revocationCache == null) {
            throw new ComponentInitializationException("RevocationCache cannot be null");
        }
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.refreshTokenChainLifetime = this.refreshTokenChainLifetimeLookupStrategy.apply(profileRequestContext);
        if (this.refreshTokenChainLifetime == null) {
            this.log.warn("{} No lifetime supplied for refresh token", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        this.refreshTokenTimeout = this.refreshTokenTimeoutLookupStrategy.apply(profileRequestContext);
        if (this.refreshTokenTimeout == null) {
            this.log.warn("{} No timeout supplied for refresh token", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
        assert (oidcResponseContext != null);
        this.tokenClaimsSet = oidcResponseContext.getAuthorizationGrantClaimsSet();
        if (this.tokenClaimsSet == null || !(this.tokenClaimsSet instanceof RefreshTokenClaimsSet) && !(this.tokenClaimsSet instanceof AuthorizeCodeClaimsSet)) {
            this.log.error("{} No token to base refresh on", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.manipulationStrategy = this.tokenClaimsSetManipulationStrategyLookupStrategy.apply(profileRequestContext);
        this.idGenerator = this.idGeneratorLookupStrategy.apply(profileRequestContext);
        if (this.idGenerator == null) {
            this.log.error("{} No identifier generation strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.refreshTokenType = this.refreshTokenTypeLookupStrategy.apply(profileRequestContext);
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        TokenClaimsSet nonNullClaimsSet = this.tokenClaimsSet;
        assert (nonNullClaimsSet != null);
        Instant now = Instant.now();
        assert (now != null);
        Instant chainExp = this.calculateChainExp(nonNullClaimsSet);
        Instant tokenExp = now.plus(this.refreshTokenTimeout);
        assert (tokenExp != null);
        OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
        assert (oidcResponseContext != null);
        String rootTokenId = StringSupport.trimOrNull((String)nonNullClaimsSet.getRootTokenIdentifier()) == null ? nonNullClaimsSet.getID() : nonNullClaimsSet.getRootTokenIdentifier();
        RefreshTokenClaimsSet.Builder builder = new RefreshTokenClaimsSet.Builder(nonNullClaimsSet, now, chainExp.isBefore(tokenExp) ? chainExp : tokenExp, chainExp);
        assert (this.idGenerator != null);
        builder.setJWTID(this.idGenerator, this.xmlSafeIdentifier);
        builder.setRootTokenIdentifier(rootTokenId);
        builder.setDpopProofJwkThumbprint(oidcResponseContext.getDpopProofJwkThumbprint());
        RefreshTokenClaimsSet claimsSet = builder.build();
        JWTClaimsSet jwtClaimsSet = claimsSet.getClaimsSet();
        assert (jwtClaimsSet != null);
        HashMap claimsMap = new HashMap(jwtClaimsSet.toJSONObject());
        for (RefreshTokenClaimsSetDecorator decorator : this.tokenClaimsSetDecorators) {
            this.log.debug("{} Applying decorator {}", (Object)this.getLogPrefix(), (Object)decorator);
            decorator.accept(claimsMap, (Object)profileRequestContext);
            try {
                JWTClaimsSet parsedClaimsSet = JWTClaimsSet.parse(claimsMap);
                assert (parsedClaimsSet != null);
                claimsSet.setClaimsSet(parsedClaimsSet);
            }
            catch (ParseException e) {
                this.log.error("{} The resulted claims set after decorator {} could not be parsed", new Object[]{this.getLogPrefix(), decorator.getId(), e});
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
                return;
            }
        }
        if (this.manipulationStrategy != null) {
            this.log.debug("{} Manipulation strategy has been set, applying it to the claims set {}", (Object)this.getLogPrefix(), (Object)claimsSet.serialize());
            JWTClaimsSet innerClaimsSet = claimsSet.getClaimsSet();
            assert (innerClaimsSet != null);
            assert (this.manipulationStrategy != null);
            Map<String, Object> result = this.manipulationStrategy.apply(profileRequestContext, innerClaimsSet.toJSONObject());
            if (result == null) {
                this.log.debug("{} Manipulation strategy returned null, leaving token claims set untouched.", (Object)this.getLogPrefix());
            } else {
                this.log.debug("{} Applying the manipulated claims into the token claims set", (Object)this.getLogPrefix());
                try {
                    JWTClaimsSet manipulatedClaimsSet = JWTClaimsSet.parse(result);
                    assert (manipulatedClaimsSet != null);
                    claimsSet.setClaimsSet(manipulatedClaimsSet);
                }
                catch (ParseException e) {
                    this.log.error("{} The resulted claims set could not be transformed into ", (Object)this.getLogPrefix(), (Object)e);
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
                    return;
                }
            }
        } else {
            this.log.debug("{} No manipulation strategy configured", (Object)this.getLogPrefix());
        }
        if (StringSupport.trimOrNull((String)this.refreshTokenType) == null) {
            try {
                oidcResponseContext.setRefreshToken(claimsSet.serialize(this.dataSealer));
            }
            catch (DataSealerException e) {
                this.log.error("{} Refresh Token generation failed {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToEncrypt");
                return;
            }
        } else {
            BiFunction<ProfileRequestContext, RefreshTokenClaimsSet, String> serializationStrategy = this.refreshTokenSerializationStrategies.get(this.refreshTokenType);
            if (serializationStrategy == null) {
                this.log.error("{} Could not find a seralization strategy for refresh token type {}", (Object)this.getLogPrefix(), (Object)this.refreshTokenType);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
                return;
            }
            String serializedToken = serializationStrategy.apply(profileRequestContext, claimsSet);
            if (serializedToken == null) {
                this.log.error("{} Could not serialize the claims set with refresh token type {}", (Object)this.getLogPrefix(), (Object)this.refreshTokenType);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
                return;
            }
            oidcResponseContext.setRefreshToken(serializedToken);
        }
        this.log.debug("{} Setting refresh token {} as {} to response context ", new Object[]{this.getLogPrefix(), claimsSet.serialize(), oidcResponseContext.getRefreshToken()});
        if (this.enforceRefreshTokenRotationCondition.test(profileRequestContext) && this.tokenClaimsSet instanceof RefreshTokenClaimsSet) {
            String jti = this.tokenClaimsSet.getID();
            assert (jti != null);
            Duration lifetime = this.tokenRevocationLifetimeLookupStrategy.apply(nonNullClaimsSet.getClaimsSet());
            if (lifetime == null || Duration.ZERO.equals(lifetime)) {
                this.log.error("{} Unable to fetch lifetime for the single token revocation", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
                return;
            }
            this.log.debug("{} Revoking the refresh token {} used for issuing the new one", (Object)this.getLogPrefix(), (Object)jti);
            if (!this.revocationCache.revoke(RevocationCacheContexts.SINGLE_ACCESS_OR_REFRESH_TOKENS, jti, lifetime)) {
                this.log.error("{} Unable to store revocation into the revocation cache", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
                return;
            }
        }
    }

    protected Instant getExistingChainExp(@Nonnull TokenClaimsSet tokenClaimsSet) {
        JWTClaimsSet claimsSet = tokenClaimsSet.getClaimsSet();
        if (claimsSet != null && claimsSet.getClaims().containsKey("c_exp")) {
            try {
                return claimsSet.getDateClaim("c_exp").toInstant();
            }
            catch (ParseException e) {
                this.log.warn("{} Could not parse the chain expiration time from the claims set", (Throwable)e);
            }
        }
        return null;
    }

    @Nonnull
    protected Instant calculateChainExp(@Nonnull TokenClaimsSet tokenClaimsSet) {
        Instant authnTime = tokenClaimsSet.getAuthenticationTime();
        Instant chainExp = authnTime != null ? authnTime.plus(this.refreshTokenChainLifetime) : Instant.now();
        Instant existingChainExp = this.getExistingChainExp(tokenClaimsSet);
        if (existingChainExp == null) {
            assert (chainExp != null);
            return chainExp;
        }
        return chainExp.isBefore(existingChainExp) ? chainExp : existingChainExp;
    }
}

