/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseConsentContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.TokenRequestConsentedAttributesLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCResponseAction;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

public class SetConsentFromTokenToResponseContext
extends AbstractOIDCResponseAction {
    @Nonnull
    private Function<ProfileRequestContext, List<Object>> consentedAttributesLookupStrategy = new TokenRequestConsentedAttributesLookupFunction();

    public void setConsentedAttributesLookupStrategy(@Nonnull Function<ProfileRequestContext, List<Object>> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.consentedAttributesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        List<Object> consentedAttributes = this.consentedAttributesLookupStrategy.apply(profileRequestContext);
        if (consentedAttributes != null) {
            OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
            assert (oidcResponseContext != null);
            OIDCAuthenticationResponseConsentContext consentClaimsCtx = (OIDCAuthenticationResponseConsentContext)oidcResponseContext.ensureSubcontext(OIDCAuthenticationResponseConsentContext.class);
            consentClaimsCtx.getConsentedAttributes().addAll(consentedAttributes);
        }
    }
}

