/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.openid.connect.sdk.Prompt;
import java.time.Duration;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.config.navigate.ForceAuthnProfileConfigPredicate;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCAuthenticationRequestAction;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class InitializeAuthenticationContext
extends AbstractOIDCAuthenticationRequestAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InitializeAuthenticationContext.class);
    @NonnullAfterInit
    private Function<ProfileRequestContext, Prompt> promptLookupStrategy;
    @NonnullAfterInit
    private Function<ProfileRequestContext, String> loginHintLookupStrategy;
    @NonnullAfterInit
    private Function<ProfileRequestContext, Duration> maxAgeLookupStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> forceAuthnPredicate = new ForceAuthnProfileConfigPredicate();

    public void setPromptLookupStrategy(@Nonnull Function<ProfileRequestContext, Prompt> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.promptLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"PromptLookupStrategy lookup strategy cannot be null");
    }

    public void setLoginHintLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.loginHintLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"LoginHintLookupStrategy lookup strategy cannot be null");
    }

    public void setMaxAgeLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.maxAgeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"MaxAgeLookupStrategy lookup strategy cannot be null");
    }

    public void setForceAuthnPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.forceAuthnPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Forced authentication predicate cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.promptLookupStrategy == null) {
            throw new ComponentInitializationException("Prompt lookup strategy cannot be null");
        }
        if (this.loginHintLookupStrategy == null) {
            throw new ComponentInitializationException("Login hint lookup strategy cannot be null");
        }
        if (this.maxAgeLookupStrategy == null) {
            throw new ComponentInitializationException("Max age type lookup strategy cannot be null");
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        String loginHint;
        Prompt prompt;
        this.log.debug("{} Initializing authentication context", (Object)this.getLogPrefix());
        AuthenticationContext authnCtx = new AuthenticationContext();
        Duration maxAge = this.maxAgeLookupStrategy.apply(profileRequestContext);
        if (maxAge != null) {
            if (maxAge.isZero()) {
                authnCtx.setMaxAge(Duration.ofSeconds(1L));
            } else {
                authnCtx.setMaxAge(maxAge);
            }
        }
        if ((prompt = this.promptLookupStrategy.apply(profileRequestContext)) != null) {
            authnCtx.setIsPassive(prompt.contains((Object)Prompt.Type.NONE));
            authnCtx.setForceAuthn(prompt.contains((Object)Prompt.Type.LOGIN));
        }
        if (!authnCtx.isForceAuthn()) {
            authnCtx.setForceAuthn(this.forceAuthnPredicate.test(profileRequestContext));
        }
        if ((loginHint = this.loginHintLookupStrategy.apply(profileRequestContext)) != null) {
            authnCtx.setHintedName(loginHint);
        }
        profileRequestContext.addSubcontext((BaseContext)authnCtx, true);
        this.log.debug("{} Created authentication context: {}", (Object)this.getLogPrefix(), (Object)authnCtx);
    }
}

