/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCResponseAction;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class AddNonceToIDToken
extends AbstractOIDCResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AddNonceToIDToken.class);
    @NonnullAfterInit
    private Function<ProfileRequestContext, Nonce> requestNonceLookupStrategy;

    public void setRequestNonceLookupStrategy(@Nonnull Function<ProfileRequestContext, Nonce> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.requestNonceLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RequestNonceLookupStrategy lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.requestNonceLookupStrategy == null) {
            throw new ComponentInitializationException("Requested nonce lookup strategy cannot be null");
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
        assert (oidcResponseContext != null);
        if (oidcResponseContext.getIDToken() == null) {
            this.log.error("{} No id token", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return;
        }
        IDTokenClaimsSet idTokenClaimsSet = oidcResponseContext.getIDToken();
        assert (idTokenClaimsSet != null);
        Nonce nonce = this.requestNonceLookupStrategy.apply(profileRequestContext);
        if (nonce != null) {
            this.log.debug("{} Setting nonce to id token", (Object)this.getLogPrefix());
            idTokenClaimsSet.setNonce(nonce);
            this.log.debug("{} Updated token {}", (Object)this.getLogPrefix(), (Object)idTokenClaimsSet.toJSONObject().toJSONString());
        }
    }
}

