/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCAuthenticationResponseAction;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class AddAcrToIDToken
extends AbstractOIDCAuthenticationResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AddAcrToIDToken.class);

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
        assert (oidcResponseContext != null);
        if (oidcResponseContext.getIDToken() == null) {
            this.log.error("{} No id token", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return;
        }
        IDTokenClaimsSet idTokenClaimsSet = oidcResponseContext.getIDToken();
        assert (idTokenClaimsSet != null);
        if (oidcResponseContext.getAcr() != null) {
            this.log.debug("{} Setting acr to id token", (Object)this.getLogPrefix());
            idTokenClaimsSet.setACR(oidcResponseContext.getAcr());
            this.log.debug("{} Updated token {}", (Object)this.getLogPrefix(), (Object)idTokenClaimsSet.toJSONObject().toJSONString());
        }
    }
}

