/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCAuthenticationRequestAction;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public abstract class AbstractOIDCAuthenticationResponseAction
extends AbstractOIDCAuthenticationRequestAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AbstractOIDCAuthenticationResponseAction.class);
    @Nullable
    private OIDCAuthenticationResponseContext oidcResponseContext;
    @Nullable
    private OIDCMetadataContext oidcMetadataContext;

    @Nullable
    public OIDCAuthenticationResponseContext getOidcResponseContext() {
        return this.oidcResponseContext;
    }

    @Nullable
    public OIDCMetadataContext getMetadataContext() {
        return this.oidcMetadataContext;
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        MessageContext outboundMessageCtx = profileRequestContext.getOutboundMessageContext();
        if (outboundMessageCtx == null) {
            this.log.error("{} No outbound message context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.oidcResponseContext = (OIDCAuthenticationResponseContext)outboundMessageCtx.getSubcontext(OIDCAuthenticationResponseContext.class);
        if (this.oidcResponseContext == null) {
            this.log.error("{} No OIDC response context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.oidcMetadataContext = (OIDCMetadataContext)profileRequestContext.ensureInboundMessageContext().getSubcontext(OIDCMetadataContext.class);
        return true;
    }
}

