/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import java.net.URI;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONArray;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseConsentContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseTokenClaimsContext;
import net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl.AbstractOAuthAuthorizationResponseAction;
import net.shibboleth.idp.plugin.oidc.op.profile.AuthorizationCodeClaimsSetDecorator;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.OIDCAuthenticationResponseContextLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.token.support.AuthorizeCodeClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.oidc.profile.config.logic.AttributeConsentFlowEnabledPredicate;
import net.shibboleth.oidc.profile.config.navigate.AuthorizationCodeClaimsSetManipulationStrategyLookupFunction;
import net.shibboleth.oidc.profile.config.navigate.AuthzCodeLifetimeLookupFunction;
import net.shibboleth.profile.context.navigate.IssuerLookupFunction;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.DataSealer;
import net.shibboleth.shared.security.DataSealerException;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import net.shibboleth.shared.security.impl.SecureRandomIdentifierGenerationStrategy;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class SetAuthorizationCodeToResponseContext
extends AbstractOAuthAuthorizationResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SetAuthorizationCodeToResponseContext.class);
    @Nonnull
    private Function<ProfileRequestContext, String> issuerLookupStrategy;
    @NonnullAfterInit
    private DataSealer dataSealer;
    @Nullable
    private IdentifierGenerationStrategy idGenerator;
    @Nonnull
    private Function<ProfileRequestContext, IdentifierGenerationStrategy> idGeneratorLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Duration> authzCodeLifetimeLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, OIDCAuthenticationResponseTokenClaimsContext> tokenClaimsContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, OIDCAuthenticationResponseConsentContext> consentContextLookupStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> consentEnabledPredicate;
    @NonnullAfterInit
    private Function<ProfileRequestContext, String> codeChallengeLookupStrategy;
    @NonnullAfterInit
    private Function<ProfileRequestContext, String> codeChallengeMethodLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> tokenClaimsSetManipulationStrategyLookupStrategy;
    @NonnullAfterInit
    private Function<ProfileRequestContext, Nonce> requestNonceLookupStrategy;
    @Nullable
    private BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>> manipulationStrategy;
    @Nonnull
    private Collection<AuthorizationCodeClaimsSetDecorator> tokenClaimsSetDecorators;
    @Nullable
    private SubjectContext subjectCtx;
    @Nullable
    private Duration authzCodeLifetime;
    @Nullable
    private String codeChallenge;
    private boolean xmlSafeIdentifier;

    @Autowired
    public SetAuthorizationCodeToResponseContext(@Nullable Collection<AuthorizationCodeClaimsSetDecorator> freeDecorators) {
        Function tccls = new ChildContextLookup(OIDCAuthenticationResponseTokenClaimsContext.class).compose((Function)new OIDCAuthenticationResponseContextLookupFunction());
        assert (tccls != null);
        this.tokenClaimsContextLookupStrategy = tccls;
        Function ccls = new ChildContextLookup(OIDCAuthenticationResponseConsentContext.class).compose((Function)new OIDCAuthenticationResponseContextLookupFunction());
        assert (ccls != null);
        this.consentContextLookupStrategy = ccls;
        this.authzCodeLifetimeLookupStrategy = new AuthzCodeLifetimeLookupFunction();
        this.issuerLookupStrategy = new IssuerLookupFunction();
        this.consentEnabledPredicate = new AttributeConsentFlowEnabledPredicate();
        this.idGeneratorLookupStrategy = FunctionSupport.constant((Object)new SecureRandomIdentifierGenerationStrategy());
        this.tokenClaimsSetManipulationStrategyLookupStrategy = new AuthorizationCodeClaimsSetManipulationStrategyLookupFunction();
        this.xmlSafeIdentifier = true;
        this.tokenClaimsSetDecorators = freeDecorators == null ? CollectionSupport.emptyList() : freeDecorators;
    }

    public void setDataSealer(@Nonnull DataSealer sealer) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.dataSealer = (DataSealer)Constraint.isNotNull((Object)sealer, (String)"DataSealer cannot be null");
    }

    public void setCodeChallengeLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.codeChallengeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Code challenge lookup strategy cannot be null");
    }

    public void setCodeChallengeMethodLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.codeChallengeMethodLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Code challenge method lookup strategy cannot be null");
    }

    public void setOIDCAuthenticationResponseTokenClaimsContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCAuthenticationResponseTokenClaimsContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.tokenClaimsContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCAuthenticationResponseTokenClaimsContext lookup strategy cannot be null");
    }

    public void setOIDCAuthenticationResponseConsentContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCAuthenticationResponseConsentContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.consentContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCAuthenticationResponseConsentContext lookup strategy cannot be null");
    }

    public void setAuthzCodeLifetimeLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.authzCodeLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Authz code lifetime lookup strategy cannot be null");
    }

    public void setIdentifierGeneratorLookupStrategy(@Nonnull Function<ProfileRequestContext, IdentifierGenerationStrategy> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.idGeneratorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"IdentifierGenerationStrategy lookup strategy cannot be null");
    }

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"IssuerLookupStrategy lookup strategy cannot be null");
    }

    public void setConsentEnabledPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.consentEnabledPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"predicate used to check if consent is enabled cannot be null");
    }

    public void setTokenClaimsSetManipulationStrategyLookupStrategy(@Nonnull Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.tokenClaimsSetManipulationStrategyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Manipulation strategy lookup strategy cannot be null");
    }

    public void setXmlSafeIdentifier(boolean flag) {
        this.checkSetterPreconditions();
        this.xmlSafeIdentifier = flag;
    }

    public void setRequestNonceLookupStrategy(@Nonnull Function<ProfileRequestContext, Nonce> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.requestNonceLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RequestNonceLookupStrategy lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.dataSealer == null) {
            throw new ComponentInitializationException("DataSealer cannot be null");
        }
        if (this.codeChallengeLookupStrategy == null) {
            throw new ComponentInitializationException("Code challenge lookup strategy cannot be null");
        }
        if (this.codeChallengeMethodLookupStrategy == null) {
            throw new ComponentInitializationException("Code challenge method lookup strategy cannot be null");
        }
        if (this.requestNonceLookupStrategy == null) {
            throw new ComponentInitializationException("Request nonce lookup strategy cannot be null");
        }
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.subjectCtx = (SubjectContext)profileRequestContext.getSubcontext(SubjectContext.class);
        if (this.subjectCtx == null) {
            this.log.warn("{} No subject context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.idGenerator = this.idGeneratorLookupStrategy.apply(profileRequestContext);
        if (this.idGenerator == null) {
            this.log.warn("{} No identifier generation strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSecurityConfiguration");
            return false;
        }
        this.authzCodeLifetime = this.authzCodeLifetimeLookupStrategy.apply(profileRequestContext);
        if (this.authzCodeLifetime == null) {
            this.log.warn("{} No authorization code lifetime available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        this.codeChallenge = this.codeChallengeLookupStrategy.apply(profileRequestContext);
        if (this.codeChallenge != null && !this.codeChallenge.isEmpty()) {
            String codeChallengeMethod = this.codeChallengeMethodLookupStrategy.apply(profileRequestContext);
            this.codeChallenge = (codeChallengeMethod != null ? codeChallengeMethod : "plain") + this.codeChallenge;
        }
        this.manipulationStrategy = this.tokenClaimsSetManipulationStrategyLookupStrategy.apply(profileRequestContext);
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        OIDCAuthenticationResponseContext responseCtx = this.getOidcResponseContext();
        assert (responseCtx != null);
        AuthorizationRequest authorizationRequest = this.getAuthorizationRequest();
        if (authorizationRequest == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            this.log.error("{} Could not resolve AuthorizationRequest message from request", (Object)this.getLogPrefix());
            return;
        }
        OIDCAuthenticationResponseConsentContext consentCtx = this.consentContextLookupStrategy.apply(profileRequestContext);
        JSONArray consented = consentCtx != null ? consentCtx.getConsentedAttributes() : null;
        ClaimsSet claims = null;
        ClaimsSet claimsID = null;
        ClaimsSet claimsUI = null;
        OIDCAuthenticationResponseTokenClaimsContext tokenClaimsCtx = this.tokenClaimsContextLookupStrategy.apply(profileRequestContext);
        if (tokenClaimsCtx != null) {
            claims = tokenClaimsCtx.getClaims();
            claimsID = tokenClaimsCtx.getIdtokenClaims();
            claimsUI = tokenClaimsCtx.getUserinfoClaims();
        }
        Instant now = Instant.now();
        Instant dateExp = now.plus(this.authzCodeLifetime);
        assert (dateExp != null);
        Scope scope = responseCtx.getScope();
        ClientID clientId = authorizationRequest.getClientID();
        assert (clientId != null);
        String issuer = this.issuerLookupStrategy.apply(profileRequestContext);
        assert (this.subjectCtx != null);
        String principal = this.subjectCtx.getPrincipalName();
        String subject = responseCtx.getSubject();
        Instant authTime = responseCtx.getAuthTime();
        URI redirectUri = responseCtx.getRedirectURI();
        if (issuer == null || principal == null | subject == null || authTime == null || redirectUri == null) {
            this.log.warn("{} Mandatory claims set variable is missing", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        assert (principal != null);
        assert (subject != null);
        assert (this.idGenerator != null);
        AuthorizeCodeClaimsSet claimsSet = (AuthorizeCodeClaimsSet)new AuthorizeCodeClaimsSet.Builder().setJWTID(this.idGenerator, this.xmlSafeIdentifier).setClientID(clientId).setIssuer(issuer).setPrincipal(principal).setSubject(subject).setIssuedAt(now).setExpiresAt(dateExp).setAuthenticationTime(authTime).setRedirectURI(redirectUri).setScope(scope).setAudience((Collection)responseCtx.getAudience()).setACR(responseCtx.getAcr()).setNonce(this.requestNonceLookupStrategy.apply(profileRequestContext)).setCodeChallenge(this.codeChallenge).setClaimsRequest(responseCtx.getRequestedClaims()).setDlClaims(claims).setDlClaimsID(claimsID).setDlClaimsUI(claimsUI).setConsentedClaims((List)consented).setConsentEnabled(Boolean.valueOf(this.consentEnabledPredicate.test(profileRequestContext))).setSessionIdentifier(responseCtx.getSessionId()).setDpopProofJwkThumbprint(responseCtx.getDpopProofJwkThumbprint()).build();
        JWTClaimsSet jwtClaimsSet = claimsSet.getClaimsSet();
        assert (jwtClaimsSet != null);
        HashMap claimsMap = new HashMap(jwtClaimsSet.toJSONObject());
        for (AuthorizationCodeClaimsSetDecorator decorator : this.tokenClaimsSetDecorators) {
            this.log.debug("{} Applying decorator {}", (Object)this.getLogPrefix(), (Object)decorator);
            decorator.accept(claimsMap, (Object)profileRequestContext);
            try {
                JWTClaimsSet parsedClaimsSet = JWTClaimsSet.parse(claimsMap);
                assert (parsedClaimsSet != null);
                claimsSet.setClaimsSet(parsedClaimsSet);
            }
            catch (ParseException e) {
                this.log.error("{} The resulted claims set after decorator {} could not be parsed", new Object[]{this.getLogPrefix(), decorator.getId(), e});
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
                return;
            }
        }
        if (this.manipulationStrategy != null) {
            this.log.debug("{} Manipulation strategy has been set, applying it to the claims set {}", (Object)this.getLogPrefix(), (Object)claimsSet.serialize());
            Map<String, Object> result = this.manipulationStrategy.apply(profileRequestContext, claimsMap);
            if (result == null) {
                this.log.debug("{} Manipulation strategy returned null, leaving token claims set untouched.", (Object)this.getLogPrefix());
            } else {
                this.log.debug("{} Applying the manipulated claims into the token claims set", (Object)this.getLogPrefix());
                try {
                    JWTClaimsSet parsedClaimsSet = JWTClaimsSet.parse(result);
                    assert (parsedClaimsSet != null);
                    claimsSet.setClaimsSet(parsedClaimsSet);
                }
                catch (ParseException e) {
                    this.log.error("{} The resulted claims set after manipulation could not be parsed ", (Object)this.getLogPrefix(), (Object)e);
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
                    return;
                }
            }
        } else {
            this.log.debug("{} No manipulation strategy configured", (Object)this.getLogPrefix());
        }
        responseCtx.setAuthorizationGrantClaimsSet((TokenClaimsSet)claimsSet);
        try {
            assert (this.dataSealer != null);
            String sealedCode = claimsSet.serialize(this.dataSealer);
            responseCtx.setAuthorizationCode(sealedCode);
            this.log.debug("{} Setting authz code {} as {} to response context ", new Object[]{this.getLogPrefix(), claimsSet.serialize(), responseCtx.getAuthorizationCode()});
        }
        catch (DataSealerException e) {
            this.log.error("{} Authorization Code generation failed {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToEncrypt");
        }
    }
}

