/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.plugin.oidc.op.encoding.impl.ResponseUtil;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.AccessTokenContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseConsentContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseTokenClaimsContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.navigate.TokenRequestClientIDLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.AccessTokenClaimsSetDecorator;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.OIDCAuthenticationResponseContextLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCResponseAction;
import net.shibboleth.idp.plugin.oidc.op.token.support.AccessTokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.AuthorizeCodeClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.RefreshTokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.oidc.profile.config.logic.AlwaysIssueBearerAccessTokenPredicate;
import net.shibboleth.oidc.profile.config.logic.AttributeConsentFlowEnabledPredicate;
import net.shibboleth.oidc.profile.config.navigate.AccessTokenClaimsSetManipulationStrategyLookupFunction;
import net.shibboleth.oidc.profile.config.navigate.AccessTokenLifetimeLookupFunction;
import net.shibboleth.oidc.profile.config.navigate.AccessTokenTypeLookupFunction;
import net.shibboleth.profile.context.navigate.IssuerLookupFunction;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.security.DataSealer;
import net.shibboleth.shared.security.DataSealerException;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import net.shibboleth.shared.security.impl.SecureRandomIdentifierGenerationStrategy;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class BuildAccessToken
extends AbstractOIDCResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(BuildAccessToken.class);
    @Nonnull
    private Logger protocolMessageLog = LoggerFactory.getLogger((String)"PROTOCOL_MESSAGE.OAUTH2");
    @NonnullAfterInit
    private DataSealer dataSealer;
    @Nonnull
    private Function<ProfileRequestContext, String> issuerLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, ClientID> clientIDLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> accessTokenTypeLookupStrategy = new AccessTokenTypeLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, Duration> accessTokenLifetimeLookupStrategy = new AccessTokenLifetimeLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, IdentifierGenerationStrategy> idGeneratorLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, OIDCAuthenticationResponseTokenClaimsContext> tokenClaimsContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, OIDCAuthenticationResponseConsentContext> consentContextLookupStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> consentEnabledPredicate;
    @Nonnull
    private Function<ProfileRequestContext, AccessTokenContext> accessTokenContextCreationStrategy;
    @Nonnull
    private Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> tokenClaimsSetManipulationStrategyLookupStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> alwaysIssueBearerAccessTokenCondition;
    @Nullable
    private BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>> manipulationStrategy;
    @Nonnull
    private Collection<AccessTokenClaimsSetDecorator> tokenClaimsSetDecorators;
    @NonnullAfterInit
    private ObjectMapper objectMapper;
    @Nullable
    private TokenClaimsSet tokenClaimsSet;
    @Nullable
    private AuthenticationRequest authenticationRequest;
    @Nullable
    private SubjectContext subjectCtx;
    private boolean jwtTokenType;
    @Nullable
    private IdentifierGenerationStrategy idGenerator;
    @Nullable
    private AccessTokenContext accessTokenCtx;
    private boolean xmlSafeIdentifier;

    @Autowired
    public BuildAccessToken(@Nullable Collection<AccessTokenClaimsSetDecorator> freeDecorators) {
        this.issuerLookupStrategy = new IssuerLookupFunction();
        this.clientIDLookupStrategy = FunctionSupport.compose((Function)((Object)new TokenRequestClientIDLookupFunction()), (Function)new InboundMessageContextLookup());
        this.idGeneratorLookupStrategy = FunctionSupport.constant((Object)new SecureRandomIdentifierGenerationStrategy());
        Function tccls = new ChildContextLookup(OIDCAuthenticationResponseTokenClaimsContext.class).compose((Function)new OIDCAuthenticationResponseContextLookupFunction());
        assert (tccls != null);
        this.tokenClaimsContextLookupStrategy = tccls;
        Function ccls = new ChildContextLookup(OIDCAuthenticationResponseConsentContext.class).compose((Function)new OIDCAuthenticationResponseContextLookupFunction());
        assert (ccls != null);
        this.consentContextLookupStrategy = ccls;
        this.consentEnabledPredicate = new AttributeConsentFlowEnabledPredicate();
        Function atccs = new ChildContextLookup(AccessTokenContext.class, true).compose(new ChildContextLookup(OIDCAuthenticationResponseContext.class).compose((Function)new OutboundMessageContextLookup()));
        assert (atccs != null);
        this.accessTokenContextCreationStrategy = atccs;
        this.tokenClaimsSetManipulationStrategyLookupStrategy = new AccessTokenClaimsSetManipulationStrategyLookupFunction();
        this.xmlSafeIdentifier = true;
        this.alwaysIssueBearerAccessTokenCondition = new AlwaysIssueBearerAccessTokenPredicate();
        this.tokenClaimsSetDecorators = freeDecorators == null ? CollectionSupport.emptyList() : freeDecorators;
    }

    public void setDataSealer(@Nullable DataSealer sealer) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.dataSealer = sealer;
    }

    public void setAccessTokenTypeLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.accessTokenTypeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Access token type lookup strategy cannot be null");
    }

    public void setAccessTokenLifetimeLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.accessTokenLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Access token lifetime lookup strategy cannot be null");
    }

    public void setIdentifierGeneratorLookupStrategy(@Nonnull Function<ProfileRequestContext, IdentifierGenerationStrategy> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.idGeneratorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Identifier generation strategy cannot be null");
    }

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Issuer lookup strategy cannot be null");
    }

    public void setClientIDLookupStrategy(@Nonnull Function<ProfileRequestContext, ClientID> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.clientIDLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ClientID lookup strategy cannot be null");
    }

    public void setOIDCAuthenticationResponseTokenClaimsContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCAuthenticationResponseTokenClaimsContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.tokenClaimsContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCAuthenticationResponseTokenClaimsContextt lookup strategy cannot be null");
    }

    public void setOIDCAuthenticationResponseConsentContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCAuthenticationResponseConsentContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.consentContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCAuthenticationResponseConsentContext lookup strategy cannot be null");
    }

    public void setConsentEnabledPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.consentEnabledPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"predicate used to check if consent is enabled cannot be null");
    }

    public void setAccessTokenContextCreationStrategy(@Nonnull Function<ProfileRequestContext, AccessTokenContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.accessTokenContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"AccessTokenContext creation strategy cannot be null");
    }

    public void setTokenClaimsSetManipulationStrategyLookupStrategy(@Nonnull Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.tokenClaimsSetManipulationStrategyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Manipulation strategy lookup strategy cannot be null");
    }

    public void setObjectMapper(@Nonnull ObjectMapper mapper) {
        this.checkSetterPreconditions();
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"Object mapper cannot be null");
    }

    public void setXmlSafeIdentifier(boolean flag) {
        this.checkSetterPreconditions();
        this.xmlSafeIdentifier = flag;
    }

    public void setAlwaysIssueBearerAccessTokenCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.alwaysIssueBearerAccessTokenCondition = (Predicate)Constraint.isNotNull(condition, (String)"Always issue bearer access token condition cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.dataSealer == null) {
            throw new ComponentInitializationException("DataSealer cannot be null");
        }
        if (this.objectMapper == null) {
            throw new ComponentInitializationException("Object mapper cannot be null");
        }
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        String tokenType = this.accessTokenTypeLookupStrategy.apply(profileRequestContext);
        boolean bl = this.jwtTokenType = tokenType != null && "JWT".equals(tokenType);
        if (!this.jwtTokenType && this.dataSealer == null) {
            this.log.error("{} DataSealer required for opaque access tokens", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToEncrypt");
            return false;
        }
        OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
        assert (oidcResponseContext != null);
        this.tokenClaimsSet = oidcResponseContext.getAuthorizationGrantClaimsSet();
        if (this.tokenClaimsSet != null && !(this.tokenClaimsSet instanceof RefreshTokenClaimsSet) && !(this.tokenClaimsSet instanceof AuthorizeCodeClaimsSet)) {
            this.log.error("{} Authorization grant is of unknown type: {}", (Object)this.getLogPrefix(), this.tokenClaimsSet != null ? this.tokenClaimsSet.getClass().getName() : null);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.idGenerator = this.idGeneratorLookupStrategy.apply(profileRequestContext);
        if (this.idGenerator == null) {
            this.log.error("{} No identifier generation strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        if (this.tokenClaimsSet == null) {
            Object object;
            this.subjectCtx = (SubjectContext)profileRequestContext.getSubcontext(SubjectContext.class);
            if (this.subjectCtx == null) {
                this.log.error("{} No subject context", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
                return false;
            }
            if (profileRequestContext.getInboundMessageContext() != null && (object = profileRequestContext.ensureInboundMessageContext().getMessage()) instanceof AuthenticationRequest) {
                AuthenticationRequest authnRequest;
                this.authenticationRequest = authnRequest = (AuthenticationRequest)object;
            }
        }
        this.accessTokenCtx = this.accessTokenContextCreationStrategy.apply(profileRequestContext);
        if (this.accessTokenCtx == null) {
            this.log.error("{} Unable to create AccessTokenContext", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        Duration lifetime = this.accessTokenLifetimeLookupStrategy.apply(profileRequestContext);
        if (lifetime == null) {
            this.log.error("{} No lifetime supplied for access token", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        assert (this.accessTokenCtx != null);
        this.accessTokenCtx.setLifetime(lifetime);
        this.manipulationStrategy = this.tokenClaimsSetManipulationStrategyLookupStrategy.apply(profileRequestContext);
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        JWTClaimsSet acClaimsSet;
        JSONObject json;
        AccessTokenClaimsSet.Builder builder;
        boolean oidc;
        String issuer = this.issuerLookupStrategy.apply(profileRequestContext);
        ClientID clientID = this.clientIDLookupStrategy.apply(profileRequestContext);
        if (issuer == null || clientID == null) {
            this.log.error("{} Unable to determine issuer or clientID, failing request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"MessageProcessingError");
            return;
        }
        ClaimsSet claims = null;
        ClaimsSet claimsUI = null;
        OIDCAuthenticationResponseTokenClaimsContext tokenClaimsCtx = this.tokenClaimsContextLookupStrategy.apply(profileRequestContext);
        if (tokenClaimsCtx != null) {
            claims = tokenClaimsCtx.getClaims();
            claimsUI = tokenClaimsCtx.getUserinfoClaims();
        }
        OIDCAuthenticationResponseContext responseCtx = this.getOidcResponseContext();
        assert (responseCtx != null);
        Scope scope = responseCtx.getScope();
        this.log.debug("{} Building access token with scope: {}", (Object)this.getLogPrefix(), (Object)scope);
        boolean bl = oidc = scope != null && scope.contains("openid");
        if (oidc) {
            responseCtx.getAudience().add(issuer);
        }
        this.log.debug("{} Building access token with audience: {}", (Object)this.getLogPrefix(), (Object)responseCtx.getAudience());
        Instant now = Instant.now();
        assert (this.accessTokenCtx != null);
        Instant dateExp = now.plus(this.accessTokenCtx.getLifetime());
        assert (dateExp != null);
        boolean alwaysBearerToken = this.alwaysIssueBearerAccessTokenCondition.test(profileRequestContext);
        this.log.debug("{} Always issue bearer access token set to {}", (Object)this.getLogPrefix(), (Object)alwaysBearerToken);
        if (this.tokenClaimsSet != null) {
            TokenClaimsSet nonNullClaimsSet = this.tokenClaimsSet;
            builder = new AccessTokenClaimsSet.Builder(nonNullClaimsSet, scope, (ClaimsSet)(oidc ? claims : null), (ClaimsSet)(oidc ? claimsUI : null), now, dateExp);
            builder.setAudience((Collection)responseCtx.getAudience());
            assert (this.idGenerator != null);
            builder.setJWTID(this.idGenerator, this.xmlSafeIdentifier);
            builder.setSessionIdentifier(responseCtx.getSessionId());
            builder.setDpopProofJwkThumbprint(alwaysBearerToken ? null : responseCtx.getDpopProofJwkThumbprint());
            if (StringSupport.trimOrNull((String)nonNullClaimsSet.getRootTokenIdentifier()) == null) {
                builder.setRootTokenIdentifier(nonNullClaimsSet.getID());
            }
        } else {
            OIDCAuthenticationResponseConsentContext consentCtx = this.consentContextLookupStrategy.apply(profileRequestContext);
            JSONArray consented = consentCtx != null ? consentCtx.getConsentedAttributes() : null;
            builder = (AccessTokenClaimsSet.Builder)new AccessTokenClaimsSet.Builder().setClientID(clientID).setIssuer(issuer).setIssuedAt(now).setExpiresAt(dateExp).setACR(responseCtx.getAcr()).setScope(scope).setAudience((Collection)responseCtx.getAudience()).setDlClaims(claims).setDlClaimsUI(claimsUI).setConsentedClaims((List)consented).setConsentEnabled(Boolean.valueOf(this.consentEnabledPredicate.test(profileRequestContext))).setSessionIdentifier(responseCtx.getSessionId()).setDpopProofJwkThumbprint(alwaysBearerToken ? null : responseCtx.getDpopProofJwkThumbprint());
            assert (this.subjectCtx != null);
            String principal = this.subjectCtx.getPrincipalName();
            if (principal != null) {
                builder.setPrincipal(principal);
            }
            assert (responseCtx != null);
            String subject = responseCtx.getSubject();
            if (subject != null) {
                builder.setSubject(subject);
            }
            assert (responseCtx != null);
            Instant authTime = responseCtx.getAuthTime();
            if (authTime != null) {
                builder.setAuthenticationTime(authTime);
            }
            assert (this.idGenerator != null);
            builder.setJWTID(this.idGenerator, this.xmlSafeIdentifier);
            if (this.authenticationRequest != null) {
                AuthenticationRequest nonNullAuthnRequest = this.authenticationRequest;
                builder.setNonce(nonNullAuthnRequest.getNonce());
                builder.setClaimsRequest(nonNullAuthnRequest.getOIDCClaims());
            }
        }
        ClaimsSet responseCtxClaimsSet = responseCtx.getAccessTokenClaimSet();
        if (this.jwtTokenType && responseCtxClaimsSet != null && (json = responseCtxClaimsSet.toJSONObject()) != null) {
            builder.setCustomClaims(json);
        }
        AccessTokenClaimsSet claimsSet = builder.build();
        JWTClaimsSet jwtClaimsSet = claimsSet.getClaimsSet();
        assert (jwtClaimsSet != null);
        HashMap claimsMap = new HashMap(jwtClaimsSet.toJSONObject());
        for (AccessTokenClaimsSetDecorator decorator : this.tokenClaimsSetDecorators) {
            this.log.debug("{} Applying decorator {}", (Object)this.getLogPrefix(), (Object)decorator);
            decorator.accept(claimsMap, (Object)profileRequestContext);
            try {
                JWTClaimsSet parsedClaimsSet = JWTClaimsSet.parse(claimsMap);
                assert (parsedClaimsSet != null);
                claimsSet.setClaimsSet(parsedClaimsSet);
            }
            catch (ParseException e) {
                this.log.error("{} The resulted claims set after decorator {} could not be parsed", new Object[]{this.getLogPrefix(), decorator.getId(), e});
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
                return;
            }
        }
        if (this.manipulationStrategy != null) {
            acClaimsSet = claimsSet.getClaimsSet();
            assert (acClaimsSet != null);
            this.log.debug("{} Manipulation strategy has been set, applying it to the claims set {}", (Object)this.getLogPrefix(), (Object)claimsSet.serialize());
            assert (this.manipulationStrategy != null);
            Map<String, Object> result = this.manipulationStrategy.apply(profileRequestContext, acClaimsSet.toJSONObject());
            if (result == null) {
                this.log.debug("{} Manipulation strategy returned null, leaving token claims set untouched.", (Object)this.getLogPrefix());
            } else {
                this.log.debug("{} Applying the manipulated claims into the token claims set", (Object)this.getLogPrefix());
                try {
                    JWTClaimsSet parsedSet = JWTClaimsSet.parse(result);
                    assert (parsedSet != null);
                    claimsSet.setClaimsSet(parsedSet);
                }
                catch (ParseException e) {
                    this.log.error("{} The resulted claims set could not be transformed into ", (Object)this.getLogPrefix(), (Object)e);
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
                    return;
                }
            }
        } else {
            this.log.debug("{} No manipulation strategy configured", (Object)this.getLogPrefix());
        }
        try {
            if (this.jwtTokenType) {
                acClaimsSet = claimsSet.getClaimsSet();
                assert (acClaimsSet != null);
                PlainJWT jwt = new PlainJWT(this.sealClaims(acClaimsSet));
                assert (this.accessTokenCtx != null);
                this.accessTokenCtx.setJWT((JWT)jwt);
                assert (this.objectMapper != null);
                this.protocolMessageLog.trace("JWT access token payload contents:\n{}", (Object)ResponseUtil.getJwtProtocolMessage((JWT)jwt, this.objectMapper));
                this.log.debug("{} Claims stored to JWT access token: {}", (Object)this.getLogPrefix(), (Object)claimsSet.serialize());
            } else {
                assert (this.dataSealer != null);
                String sealedToken = claimsSet.serialize(this.dataSealer);
                assert (this.accessTokenCtx != null);
                this.accessTokenCtx.setOpaque(sealedToken);
                this.log.debug("{} Claims converted to opaque access token: {}", (Object)this.getLogPrefix(), (Object)claimsSet.serialize());
            }
        }
        catch (ParseException | DataSealerException e) {
            this.log.error("{} Access Token wrapping failed: {}", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"MessageProcessingError");
        }
    }

    @Nonnull
    private JWTClaimsSet sealClaims(@Nonnull JWTClaimsSet claims) throws DataSealerException, ParseException {
        Map map = claims.toJSONObject();
        HashMap toSeal = new HashMap();
        if (map.containsKey("type")) {
            toSeal.put("type", map.remove("type"));
        }
        if (map.containsKey("prncpl")) {
            toSeal.put("prncpl", map.remove("prncpl"));
        }
        if (map.containsKey("dl_claims")) {
            toSeal.put("dl_claims", map.remove("dl_claims"));
        }
        if (map.containsKey("dl_claims_ui")) {
            toSeal.put("dl_claims_ui", map.remove("dl_claims_ui"));
        }
        if (map.containsKey("cnsntd_claims")) {
            toSeal.put("cnsntd_claims", map.remove("cnsntd_claims"));
        }
        if (map.containsKey("cnsnt")) {
            toSeal.put("cnsnt", map.remove("cnsnt"));
        }
        if (map.containsKey("cc")) {
            toSeal.put("cc", map.remove("cc"));
        }
        if (map.containsKey("nonce")) {
            toSeal.put("nonce", map.remove("nonce"));
        }
        if (toSeal.isEmpty()) {
            return claims;
        }
        JWTClaimsSet claimsSetToSeal = JWTClaimsSet.parse(toSeal);
        assert (claimsSetToSeal != null);
        String stringToSeal = claimsSetToSeal.toString();
        assert (stringToSeal != null);
        String sealed = this.dataSealer.wrap(stringToSeal);
        map.put("for_op", sealed);
        JWTClaimsSet result = JWTClaimsSet.parse((Map)map);
        assert (result != null);
        return result;
    }
}

