/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.metadata.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.metadata.resolver.MetadataValueResolver;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.profile.context.ProfileRequestContext;

public class FunctionMetadataValueResolver
extends AbstractIdentifiableInitializableComponent
implements MetadataValueResolver {
    @NonnullAfterInit
    private Function<ProfileRequestContext, Object> resolverFunction;

    public void setResolverFunction(@Nonnull Function<ProfileRequestContext, Object> function) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.resolverFunction = (Function)Constraint.isNotNull(function, (String)"Resolver function cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.resolverFunction == null) {
            throw new ComponentInitializationException("Resolver function can not be null");
        }
    }

    @Nonnull
    public Iterable<Object> resolve(@Nullable ProfileRequestContext criteria) throws ResolverException {
        Object result = this.resolveSingle(criteria);
        return result == null ? CollectionSupport.emptyList() : CollectionSupport.listOf((Object)result);
    }

    @Nullable
    public Object resolveSingle(@Nullable ProfileRequestContext criteria) throws ResolverException {
        return this.resolverFunction.apply(criteria);
    }
}

