/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.metadata.impl;

import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.RSAKey;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONArray;
import net.shibboleth.idp.plugin.oidc.op.metadata.resolver.MetadataValueResolver;
import net.shibboleth.oidc.profile.config.JSONSecurityConfiguration;
import net.shibboleth.oidc.security.credential.JWKCredential;
import net.shibboleth.oidc.security.jose.SignatureSigningConfiguration;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.config.SecurityConfiguration;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.UsageType;
import org.slf4j.Logger;

public class CredentialMetadataValueResolver
extends AbstractIdentifiableInitializableComponent
implements MetadataValueResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(CredentialMetadataValueResolver.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public JWK parseJwkCredential(@Nonnull Credential credential) {
        RSAKey jwk;
        KeyUse use;
        Constraint.isNotNull((Object)credential, (String)"Credential cannot be null");
        PublicKey publicKey = credential.getPublicKey();
        String kid = credential instanceof JWKCredential ? ((JWKCredential)credential).getKid() : null;
        UsageType usageType = credential.getUsageType();
        if (usageType != null) {
            switch (usageType) {
                case SIGNING: {
                    use = KeyUse.SIGNATURE;
                    break;
                }
                case ENCRYPTION: {
                    use = KeyUse.ENCRYPTION;
                    break;
                }
                default: {
                    use = null;
                    break;
                }
            }
        } else {
            use = null;
        }
        if (publicKey instanceof RSAPublicKey) {
            RSAKey.Builder builder = new RSAKey.Builder((RSAPublicKey)publicKey).keyID(kid).keyUse(use);
            if (credential instanceof JWKCredential) {
                builder.algorithm(((JWKCredential)credential).getAlgorithm());
            }
            jwk = builder.build();
        } else if (publicKey instanceof ECPublicKey) {
            Curve curve = Curve.forECParameterSpec((ECParameterSpec)((ECPublicKey)publicKey).getParams());
            ECKey.Builder builder = new ECKey.Builder(curve, (ECPublicKey)publicKey);
            if (credential instanceof JWKCredential) {
                builder.algorithm(((JWKCredential)credential).getAlgorithm());
            }
            jwk = builder.build();
        } else {
            this.log.warn("Unsupported public key {}", (Object)(publicKey == null ? null : publicKey.getAlgorithm()));
            throw new ConstraintViolationException("Unsupported public key algorithm");
        }
        return jwk;
    }

    public Iterable<Object> resolve(ProfileRequestContext profileRequestContext) throws ResolverException {
        ArrayList<Object> result = new ArrayList<Object>();
        RelyingPartyContext rpCtx = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        if (rpCtx == null || rpCtx.getProfileConfig() == null) {
            this.log.warn("Could not find profile configuration, nothing to do");
            return result;
        }
        ProfileConfiguration profileConfig = rpCtx.getProfileConfig();
        assert (profileConfig != null);
        SecurityConfiguration securityConfig = profileConfig.getSecurityConfiguration(profileRequestContext);
        if (securityConfig instanceof JSONSecurityConfiguration) {
            JSONSecurityConfiguration jsonSecurityConfig = (JSONSecurityConfiguration)securityConfig;
            SignatureSigningConfiguration jwtSignatureSigningConfiguration = jsonSecurityConfig.getJwtSignatureSigningConfiguration();
            if (jwtSignatureSigningConfiguration == null) {
                this.log.warn("Could not find signing configuration, nothing to do");
                return result;
            }
            List credentials = jwtSignatureSigningConfiguration.getSigningCredentials();
            JSONArray jwkCredentials = new JSONArray();
            for (Credential credential : credentials) {
                assert (credential != null);
                try {
                    jwkCredentials.add((Object)this.parseJwkCredential(credential).toJSONObject());
                }
                catch (ConstraintViolationException e) {
                    this.log.warn("Ignoring key from the resulting list", (Throwable)e);
                }
            }
            result.add(jwkCredentials);
            return result;
        }
        if (securityConfig == null) {
            this.log.warn("Could not find security configuration, nothing to do");
        } else {
            this.log.warn("Security configuration class was not expected: {}", (Object)securityConfig);
        }
        return result;
    }

    public Object resolveSingle(@Nullable ProfileRequestContext profileRequestContext) throws ResolverException {
        Iterator<Object> iterator = this.resolve(profileRequestContext).iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }
}

