/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.messaging.context.navigate;

import com.nimbusds.jwt.JWT;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.PushedAuthorizationRequest;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.navigate.AbstractAuthenticationRequestLookupFunction;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class DefaultRequestedAcrLookupFunction
extends AbstractAuthenticationRequestLookupFunction<List<ACR>> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultRequestedAcrLookupFunction.class);

    @Override
    @Nullable
    protected List<ACR> doLookup(@Nonnull AuthenticationRequest req, @Nullable PushedAuthorizationRequest parRequest, @Nullable JWT requestObject, boolean isRequestObjectFromPar) {
        try {
            if (requestObject != null && requestObject.getJWTClaimsSet().getClaim("acr_values") != null) {
                String[] acrs;
                ArrayList<ACR> reqObjectAcr = new ArrayList<ACR>();
                for (String acr : acrs = requestObject.getJWTClaimsSet().getStringClaim("acr_values").split(" ")) {
                    reqObjectAcr.add(new ACR(acr));
                }
                return reqObjectAcr;
            }
        }
        catch (ParseException e) {
            this.log.error("Unable to parse acr values from request object acr_values value");
            return null;
        }
        if (req.getACRValues() == null) {
            return null;
        }
        ArrayList requestParameterAcr = new ArrayList();
        requestParameterAcr.addAll(req.getACRValues());
        return this.checkRequestObject((AuthorizationRequest)req, isRequestObjectFromPar, "acr_values", requestParameterAcr, null);
    }
}

